/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.standard;

import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMax;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeMin;
import com.github.mygreen.supercsv.annotation.constraint.CsvDateTimeRange;
import com.github.mygreen.supercsv.annotation.format.CsvDateTimeFormat;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMaxFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeMinFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.DateTimeRangeFactory;
import com.github.mygreen.supercsv.cellprocessor.format.DateFormatWrapper;
import com.github.mygreen.supercsv.cellprocessor.format.SimpleDateFormatBuilder;
import com.github.mygreen.supercsv.util.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

public abstract class AbstractDateProcessorBuilder<T extends Date>
extends AbstractProcessorBuilder<T> {
    @Override
    protected void init() {
        super.init();
        this.registerForConstraint(CsvDateTimeRange.class, new DateTimeRangeFactory());
        this.registerForConstraint(CsvDateTimeMin.class, new DateTimeMinFactory());
        this.registerForConstraint(CsvDateTimeMax.class, new DateTimeMaxFactory());
    }

    @Override
    protected DateFormatWrapper<T> getDefaultFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvDateTimeFormat> formatAnno = field.getAnnotation(CsvDateTimeFormat.class);
        if (!formatAnno.isPresent()) {
            return new DateFormatWrapper(new SimpleDateFormat(this.getDefaultPattern()), field.getType());
        }
        String pattern = formatAnno.get().pattern();
        if (pattern.isEmpty()) {
            pattern = this.getDefaultPattern();
        }
        boolean lenient = formatAnno.get().lenient();
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        TimeZone timeZone = formatAnno.get().timezone().isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(formatAnno.get().timezone());
        SimpleDateFormat formatter = SimpleDateFormatBuilder.create(pattern).lenient(lenient).locale(locale).timeZone(timeZone).build();
        DateFormatWrapper wrapper = new DateFormatWrapper(formatter, field.getType());
        wrapper.setValidationMessage(formatAnno.get().message());
        return wrapper;
    }

    protected abstract String getDefaultPattern();
}

