/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder;

import com.github.mygreen.supercsv.annotation.CsvComposition;
import com.github.mygreen.supercsv.annotation.CsvOverridesAttribute;
import com.github.mygreen.supercsv.annotation.constraint.CsvConstraint;
import com.github.mygreen.supercsv.annotation.conversion.CsvConversion;
import com.github.mygreen.supercsv.builder.BuildCase;
import com.github.mygreen.supercsv.builder.ExpandedAnnotation;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import com.github.mygreen.supercsv.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.exception.SuperCsvReflectionException;

public class AnnotationExpander {
    private final Comparator<ExpandedAnnotation> comparator;

    public AnnotationExpander(final Comparator<Annotation> annotationComparator) {
        Objects.requireNonNull(annotationComparator);
        this.comparator = new Comparator<ExpandedAnnotation>(){

            @Override
            public int compare(ExpandedAnnotation o1, ExpandedAnnotation o2) {
                return annotationComparator.compare(o1.getOriginal(), o2.getOriginal());
            }
        };
    }

    public List<ExpandedAnnotation> expand(Annotation[] targetAnnos) {
        Objects.requireNonNull(targetAnnos);
        ArrayList<ExpandedAnnotation> expanedList = new ArrayList<ExpandedAnnotation>();
        for (Annotation targetAnno : targetAnnos) {
            expanedList.addAll(this.expand(targetAnno));
        }
        Collections.sort(expanedList, this.comparator);
        return expanedList;
    }

    public List<ExpandedAnnotation> expand(Annotation targetAnno) {
        Objects.requireNonNull(targetAnno);
        ArrayList<ExpandedAnnotation> expandedList = new ArrayList<ExpandedAnnotation>();
        if (this.isRepeated(targetAnno)) {
            try {
                Method method = targetAnno.getClass().getMethod("value", new Class[0]);
                Annotation[] annos = (Annotation[])method.invoke((Object)targetAnno, new Object[0]);
                int index = 0;
                for (Annotation anno : annos) {
                    List<ExpandedAnnotation> repeatedAnnos = this.expand(anno);
                    for (ExpandedAnnotation repeatedAnno : repeatedAnnos) {
                        repeatedAnno.setIndex(index);
                    }
                    expandedList.addAll(repeatedAnnos);
                    ++index;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("fail get repeated value attribute.", e);
            }
        } else if (this.isComposed(targetAnno)) {
            ExpandedAnnotation composedAnno = new ExpandedAnnotation(targetAnno, true);
            List<Annotation> childAnnos = Arrays.asList(targetAnno.annotationType().getAnnotations());
            for (Annotation anno : childAnnos) {
                List<ExpandedAnnotation> nestedAnnos = this.expand(anno).stream().map(nestedAnno -> this.overrideAttribute(targetAnno, (ExpandedAnnotation)nestedAnno)).collect(Collectors.toList());
                composedAnno.addChilds(nestedAnnos);
            }
            Collections.sort(composedAnno.getChilds(), this.comparator);
            expandedList.add(composedAnno);
        } else {
            expandedList.add(new ExpandedAnnotation(targetAnno, false));
        }
        Collections.sort(expandedList, this.comparator);
        return expandedList;
    }

    private boolean isRepeated(Annotation targetAnno) {
        try {
            Method method = targetAnno.getClass().getMethod("value", new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (!returnType.isArray() || !Annotation.class.isAssignableFrom(returnType.getComponentType())) {
                return false;
            }
            Annotation[] annos = (Annotation[])method.invoke((Object)targetAnno, new Object[0]);
            if (annos.length == 0) {
                return false;
            }
            if (annos[0].annotationType().getAnnotation(Repeatable.class) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isComposed(Annotation targetAnno) {
        return targetAnno.annotationType().getAnnotation(CsvComposition.class) != null;
    }

    private ExpandedAnnotation overrideAttribute(Annotation compositionAnno, ExpandedAnnotation nestedAnno) {
        Annotation originalAnno = nestedAnno.getOriginal();
        if (!this.isOverridableAnnotation(originalAnno)) {
            return nestedAnno;
        }
        final Map<String, Object> overrideAttrs = this.buildOverrideAttribute(compositionAnno, nestedAnno);
        if (overrideAttrs.isEmpty()) {
            return nestedAnno;
        }
        final Class<? extends Annotation> annotationClass = originalAnno.annotationType();
        final HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        for (Method method : annotationClass.getMethods()) {
            try {
                Object value;
                method.setAccessible(true);
                if (method.getParameterCount() == 0) {
                    value = method.invoke((Object)originalAnno, new Object[0]);
                    defaultValues.put(method.getName(), value);
                    continue;
                }
                value = method.getDefaultValue();
                if (value == null) continue;
                defaultValues.put(method.getName(), value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(String.format("fail get annotation attribute %s#%s.", annotationClass.getName(), method.getName()), e);
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object annoObj = Proxy.newProxyInstance(classLoader, new Class[]{annotationClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if (name.equals("annotationType")) {
                    return annotationClass;
                }
                if (overrideAttrs.containsKey(name)) {
                    return overrideAttrs.get(name);
                }
                return defaultValues.get(name);
            }
        });
        ExpandedAnnotation propagatedAnno = new ExpandedAnnotation((Annotation)annoObj, nestedAnno.isComposed());
        propagatedAnno.setIndex(nestedAnno.getIndex());
        propagatedAnno.addChilds(nestedAnno.getChilds());
        return propagatedAnno;
    }

    private boolean isOverridableAnnotation(Annotation targetAnno) {
        Class<? extends Annotation> annoType = targetAnno.annotationType();
        if (annoType.getAnnotation(CsvConstraint.class) != null) {
            return true;
        }
        if (annoType.getAnnotation(CsvConversion.class) != null) {
            return true;
        }
        return annoType.getTypeName().startsWith("com.github.mygreen.supercsv.annotation.format");
    }

    private Map<String, Object> buildOverrideAttribute(Annotation compositionAnno, ExpandedAnnotation targetAnno) {
        Optional<BuildCase[]> casesAttr;
        Optional<Class[]> groupsAttr;
        Optional<String> messageAttr;
        Annotation originalAnno = targetAnno.getOriginal();
        HashMap<String, Object> overrideAttrs = new HashMap<String, Object>();
        HashSet<String> overrideMethodNames = new HashSet<String>();
        for (Method compositionMethod : compositionAnno.annotationType().getMethods()) {
            CsvOverridesAttribute.List overrideAttrAnnoList;
            ArrayList<CsvOverridesAttribute> annoList = new ArrayList<CsvOverridesAttribute>();
            CsvOverridesAttribute overrideAttrAnno = compositionMethod.getAnnotation(CsvOverridesAttribute.class);
            if (overrideAttrAnno != null) {
                annoList.add(overrideAttrAnno);
            }
            if ((overrideAttrAnnoList = compositionMethod.getAnnotation(CsvOverridesAttribute.List.class)) != null) {
                annoList.addAll(Arrays.asList(overrideAttrAnnoList.value()));
            }
            if (annoList.isEmpty()) continue;
            overrideMethodNames.add(compositionMethod.getName());
            for (CsvOverridesAttribute anno : annoList) {
                String attrName;
                if (!anno.annotation().equals(originalAnno.annotationType()) || anno.index() >= 0 && anno.index() != targetAnno.getIndex()) continue;
                String string = attrName = anno.name().isEmpty() ? compositionMethod.getName() : anno.name();
                if (!Utils.hasAnnotationAttribute(originalAnno, attrName, compositionMethod.getReturnType())) {
                    throw new SuperCsvInvalidAnnotationException(originalAnno, MessageBuilder.create("anno.CsvOverridesAnnotation.notFoundAttr").varWithAnno("compositionAnno", compositionAnno.annotationType()).varWithAnno("overrideAnno", originalAnno.annotationType()).varWithClass("attrType", compositionMethod.getReturnType()).var("attrName", attrName).format());
                }
                try {
                    Object attrValue = compositionMethod.invoke((Object)compositionAnno, new Object[0]);
                    overrideAttrs.put(attrName, attrValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new SuperCsvReflectionException(MessageBuilder.create("anno.CsvOverridesAnnotation.failGetAttr").varWithAnno("compositionAnno", compositionAnno.annotationType()).var("attrName", attrName).format(), (Throwable)e);
                }
            }
        }
        if (!overrideAttrs.containsKey("message") && !overrideMethodNames.contains("message") && Utils.hasAnnotationAttribute(originalAnno, "message", String.class) && (messageAttr = Utils.getAnnotationAttribute(compositionAnno, "message", String.class)).isPresent() && Utils.isNotEmpty(messageAttr.get())) {
            overrideAttrs.put("message", messageAttr.get());
        }
        if (!overrideAttrs.containsKey("groups") && !overrideMethodNames.contains("groups") && Utils.hasAnnotationAttribute(originalAnno, "groups", Class[].class) && (groupsAttr = Utils.getAnnotationAttribute(compositionAnno, "groups", Class[].class)).isPresent() && Utils.isNotEmpty(groupsAttr.get())) {
            overrideAttrs.put("groups", groupsAttr.get());
        }
        if (!overrideAttrs.containsKey("cases") && !overrideMethodNames.contains("cases") && Utils.hasAnnotationAttribute(originalAnno, "cases", BuildCase[].class) && (casesAttr = Utils.getAnnotationAttribute(compositionAnno, "cases", BuildCase[].class)).isPresent() && Utils.isNotEmpty((Object[])casesAttr.get())) {
            overrideAttrs.put("cases", casesAttr.get());
        }
        return overrideAttrs;
    }
}

