/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.localization;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.supercsv.ext.localization.MessageResolver;

public class ResourceBundleMessageResolver
implements MessageResolver {
    public static final String USER_MESSAGE = "SuperCsvMessages";
    public static final String DEFAULT_MESSAGE = String.format("%s.%s", ResourceBundleMessageResolver.class.getPackage().getName(), "SuperCsvMessages");
    private final Map<ResourceBundle, List<String>> messageBundleKeys = new HashMap<ResourceBundle, List<String>>(8);
    private final LinkedList<ResourceBundle> messageBundles = new LinkedList();
    public static final ResourceBundleMessageResolver INSTANCE = new ResourceBundleMessageResolver();

    public ResourceBundleMessageResolver() {
        this.addMessageBundle(ResourceBundle.getBundle(DEFAULT_MESSAGE));
        try {
            this.addMessageBundle(ResourceBundle.getBundle(USER_MESSAGE));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getMessage(String code) {
        for (ResourceBundle bundle : this.messageBundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(code)) continue;
            return bundle.getString(code);
        }
        return null;
    }

    public final boolean addMessageBundle(ResourceBundle messageBundle) {
        if (this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.addFirst(messageBundle);
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> keysEnum = messageBundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        this.messageBundleKeys.put(messageBundle, keys);
        return true;
    }

    public boolean removeMessageBundle(ResourceBundle messageBundle) {
        if (!this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.remove(messageBundle);
        return true;
    }
}

