/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.localization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.exception.SuperCsvNoMatchColumnSizeException;
import org.supercsv.ext.exception.SuperCsvNoMatchHeaderException;
import org.supercsv.ext.exception.SuperCsvRowException;
import org.supercsv.ext.localization.CsvMessage;
import org.supercsv.util.CsvContext;

public class CsvExceptionConveter {
    public List<CsvMessage> convertCsvError(SuperCsvException exception) {
        return this.convertCsvError(exception, null);
    }

    public List<CsvMessage> convertCsvError(SuperCsvException exception, String[] headers) {
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        ArrayList<CsvMessage> errors = new ArrayList<CsvMessage>();
        if (exception instanceof SuperCsvNoMatchColumnSizeException) {
            errors.addAll(this.convertCsvError((SuperCsvNoMatchColumnSizeException)exception, headers));
        } else if (exception instanceof SuperCsvNoMatchHeaderException) {
            errors.addAll(this.convertCsvError((SuperCsvNoMatchHeaderException)exception, headers));
        } else if (exception instanceof SuperCsvRowException) {
            errors.addAll(this.convertCsvError((SuperCsvRowException)exception, headers));
        } else if (exception instanceof SuperCsvCellProcessorException) {
            errors.addAll(this.convertCsvError((SuperCsvCellProcessorException)((Object)exception), headers));
        } else {
            CsvMessage error = new CsvMessage("csvError");
            error.addAll(this.createCsvContextVariable(exception.getCsvContext(), headers));
            errors.add(error);
        }
        return errors;
    }

    public List<CsvMessage> convertCsvError(SuperCsvRowException exception, String[] headers) {
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        ArrayList<CsvMessage> messages = new ArrayList<CsvMessage>();
        for (SuperCsvException e : exception.getColumnErrors()) {
            messages.addAll(this.convertCsvError(e, headers));
        }
        return messages;
    }

    public List<CsvMessage> convertCsvError(SuperCsvCellProcessorException exception, String[] headers) {
        CsvMessage message;
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        CellProcessor cellProcessor = exception.getProcessor();
        if (cellProcessor instanceof ValidationCellProcessor) {
            ValidationCellProcessor p = (ValidationCellProcessor)cellProcessor;
            message = new CsvMessage(p.getMessageCode());
            message.addAll(p.getMessageVariable());
            Object source = exception.getCsvContext().getRowSource().get(exception.getCsvContext().getColumnNumber() - 1);
            message.add("value", p.formatValue(source));
        } else {
            message = new CsvMessage(cellProcessor.getClass().getCanonicalName() + ".violated");
            Object source = exception.getCsvContext().getRowSource().get(exception.getCsvContext().getColumnNumber() - 1);
            if (source != null) {
                message.add("value", source.toString());
            } else {
                message.add("value", "");
            }
        }
        message.addAll(this.createCsvContextVariable(exception.getCsvContext(), headers));
        ArrayList<CsvMessage> errors = new ArrayList<CsvMessage>();
        errors.add(message);
        return errors;
    }

    public List<CsvMessage> convertCsvError(SuperCsvConstraintViolationException exception, String[] headers) {
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        return this.convertCsvError((SuperCsvCellProcessorException)exception, headers);
    }

    public List<CsvMessage> convertCsvError(SuperCsvNoMatchColumnSizeException exception, String[] headers) {
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        CsvMessage message = new CsvMessage("csvError.noMatchColumnSize");
        message.add("lineNumber", String.valueOf(exception.getCsvContext().getLineNumber()));
        message.add("rowNumber", String.valueOf(exception.getCsvContext().getRowNumber()));
        message.add("columnNumber", String.valueOf(exception.getCsvContext().getColumnNumber()));
        message.add("value", String.valueOf(exception.getActualColumnSize())).add("expectedSize", String.valueOf(exception.getEpxpectedColumnSize()));
        int colIndex = exception.getCsvContext().getColumnNumber();
        if (headers != null && headers.length >= colIndex) {
            message.add("columnLabel", headers[colIndex - 1]);
        }
        ArrayList<CsvMessage> errors = new ArrayList<CsvMessage>();
        errors.add(message);
        return errors;
    }

    public List<CsvMessage> convertCsvError(SuperCsvNoMatchHeaderException exception, String[] headers) {
        if (exception == null) {
            throw new NullPointerException("exception should not be null.");
        }
        CsvMessage message = new CsvMessage("csvError.notMatchHeader");
        message.add("lineNumber", String.valueOf(exception.getCsvContext().getLineNumber()));
        message.add("rowNumber", String.valueOf(exception.getCsvContext().getRowNumber()));
        message.add("columnNumber", String.valueOf(exception.getCsvContext().getColumnNumber()));
        message.add("value", exception.getActualHeadersWithJoin(",")).add("expectedValue", exception.getExpectedHeadersWithJoin(","));
        int colIndex = exception.getCsvContext().getColumnNumber();
        if (headers != null && headers.length >= colIndex) {
            message.add("columnLabel", headers[colIndex - 1]);
        }
        ArrayList<CsvMessage> errors = new ArrayList<CsvMessage>();
        errors.add(message);
        return errors;
    }

    public Map<String, ?> createCsvContextVariable(CsvContext context, String[] headers) {
        if (context == null) {
            throw new NullPointerException("context should not be null.");
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("lineNumber", context.getLineNumber());
        vars.put("rowNumber", context.getRowNumber());
        vars.put("columnNumber", context.getColumnNumber());
        int colIndex = context.getColumnNumber();
        if (headers != null && headers.length >= colIndex) {
            vars.put("columnLabel", headers[colIndex - 1]);
        }
        return vars;
    }
}

