/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.io;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.ext.exception.SuperCsvNoMatchColumnSizeException;
import org.supercsv.ext.exception.SuperCsvRowException;
import org.supercsv.ext.localization.CsvExceptionConveter;
import org.supercsv.ext.localization.CsvMessage;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.io.ICsvBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;
import org.supercsv.util.MethodCache;

public class ValidatableCsvBeanWriter
extends AbstractCsvWriter
implements ICsvBeanWriter {
    protected final List<Object> beanValues = new ArrayList<Object>();
    protected final List<Object> processedColumns = new ArrayList<Object>();
    protected final MethodCache cache = new MethodCache();
    protected CsvExceptionConveter exceptionConverter = new CsvExceptionConveter();
    private final List<CsvMessage> errors = new ArrayList<CsvMessage>();

    public CsvExceptionConveter getExceptionConverter() {
        return this.exceptionConverter;
    }

    public void setExceptionConverter(CsvExceptionConveter exceptionConverter) {
        this.exceptionConverter = exceptionConverter;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean hasNotError() {
        return !this.hasError();
    }

    public List<CsvMessage> getCsvErrors() {
        return this.errors;
    }

    public ValidatableCsvBeanWriter(Writer writer, CsvPreference preference) {
        super(writer, preference);
    }

    protected void extractBeanValues(Object source, String[] nameMapping) throws SuperCsvReflectionException {
        if (source == null) {
            throw new NullPointerException("the bean to write should not be null");
        }
        if (nameMapping == null) {
            throw new NullPointerException("the nameMapping array can't be null as it's used to map from fields to columns");
        }
        this.beanValues.clear();
        for (int i = 0; i < nameMapping.length; ++i) {
            String fieldName = nameMapping[i];
            if (fieldName == null) {
                this.beanValues.add(null);
                continue;
            }
            Method getMethod = this.cache.getGetMethod(source, fieldName);
            try {
                this.beanValues.add(getMethod.invoke(source, new Object[0]));
                continue;
            }
            catch (Exception e) {
                throw new SuperCsvReflectionException(String.format("error extracting bean value for field %s", fieldName), (Throwable)e);
            }
        }
    }

    public void write(Object source, String ... nameMapping) throws IOException {
        super.incrementRowAndLineNo();
        this.extractBeanValues(source, nameMapping);
        super.writeRow(this.beanValues);
    }

    public void write(Object source, String[] nameMapping, CellProcessor[] processors) throws IOException {
        super.incrementRowAndLineNo();
        this.extractBeanValues(source, nameMapping);
        try {
            this.executeCellProcessors(this.processedColumns, this.beanValues, processors, this.getLineNumber(), this.getRowNumber());
        }
        catch (SuperCsvRowException e) {
            throw e;
        }
        catch (SuperCsvException e) {
            this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
            throw e;
        }
        super.writeRow(this.processedColumns);
    }

    protected void executeCellProcessors(List<Object> destination, List<?> source, CellProcessor[] processors, int lineNo, int rowNo) {
        if (destination == null) {
            throw new NullPointerException("destination should not be null");
        }
        if (source == null) {
            throw new NullPointerException("source should not be null");
        }
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        CsvContext context = new CsvContext(lineNo, rowNo, 1);
        context.setRowSource(new ArrayList(source));
        if (source.size() != processors.length) {
            throw new SuperCsvNoMatchColumnSizeException(source.size(), processors.length, context);
        }
        destination.clear();
        SuperCsvRowException columnError = new SuperCsvRowException(String.format("row (%d) has errors column", rowNo), context);
        for (int i = 0; i < source.size(); ++i) {
            try {
                context.setColumnNumber(i + 1);
                if (processors[i] == null) {
                    destination.add(source.get(i));
                    continue;
                }
                destination.add(processors[i].execute(source.get(i), context));
                continue;
            }
            catch (SuperCsvCellProcessorException e) {
                columnError.addError(e);
                this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
                continue;
            }
            catch (SuperCsvException e) {
                columnError.addError(e);
                this.errors.addAll(this.exceptionConverter.convertCsvError(e, this.getDefinedHeader()));
            }
        }
        if (columnError.isNotEmptyColumnErrors()) {
            throw columnError;
        }
    }

    public String[] getDefinedHeader() {
        return null;
    }
}

