/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.joda;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class FutureJoda<T extends ReadablePartial>
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    private final T min;
    private DateTimeFormatter formatter;

    public FutureJoda(T min) {
        FutureJoda.checkPreconditions(min);
        this.min = min;
    }

    public FutureJoda(T min, CellProcessor next) {
        super(next);
        FutureJoda.checkPreconditions(min);
        this.min = min;
    }

    private static <T extends ReadablePartial> void checkPreconditions(T min) {
        if (min == null) {
            throw new NullPointerException("min should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Class<?> exepectedClass = this.getMin().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        ReadablePartial result = (ReadablePartial)value;
        if (result.compareTo(this.min) < 0) {
            throw new SuperCsvConstraintViolationException(String.format("%s does not lie the min (%s) values (inclusive)", result, this.min), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, T> vars = new HashMap<String, T>();
        vars.put("min", this.getMin());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof ReadablePartial) {
            ReadablePartial rp = (ReadablePartial)value;
            if (this.getFormatter() != null) {
                return this.getFormatter().print(rp);
            }
        }
        return value.toString();
    }

    public T getMin() {
        return this.min;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }
}

