/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class StrPattern
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    private final Pattern pattern;

    public StrPattern(Pattern pattern) {
        StrPattern.checkPreconditions(pattern);
        this.pattern = pattern;
    }

    public StrPattern(Pattern pattern, StringCellProcessor next) {
        super((CellProcessor)next);
        StrPattern.checkPreconditions(pattern);
        this.pattern = pattern;
    }

    private static void checkPreconditions(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern should not be null");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        boolean matches = this.pattern.matcher((String)value).matches();
        if (!matches) {
            String regex = this.getRegex();
            throw new SuperCsvConstraintViolationException(String.format("'%s' does not match the regular expression '%s'", value, regex), context, (CellProcessor)this);
        }
        return (T)this.next.execute(value, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("regex", this.getRegex());
        return vars;
    }

    public String getRegex() {
        return this.pattern.pattern();
    }
}

