/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class StrReplace
extends CellProcessorAdaptor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    private final Pattern pattern;
    private final String replacement;

    public StrReplace(Pattern pattern, String replacement) {
        StrReplace.checkPreconditions(pattern, replacement);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public StrReplace(Pattern pattern, String replacement, StringCellProcessor next) {
        super((CellProcessor)next);
        StrReplace.checkPreconditions(pattern, replacement);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    private static void checkPreconditions(Pattern pattern, String replacement) {
        if (pattern == null) {
            throw new NullPointerException("regex should not be null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement should not be null");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        Matcher matcher = this.pattern.matcher(value.toString());
        if (matcher.matches()) {
            String result = matcher.replaceAll(this.replacement);
            return (T)this.next.execute((Object)result, context);
        }
        return (T)this.next.execute(value, context);
    }
}

