/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseEnum
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final Class<? extends Enum<?>> type;
    protected final boolean ignoreCase;
    protected final Map<String, Enum<?>> enumValueMap;
    protected final Method valueMethod;

    public <T extends Enum<T>> ParseEnum(Class<T> type) {
        this(type, false);
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, CellProcessor next) {
        this(type, false, next);
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, String valueMethodName) {
        this(type, false, valueMethodName);
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, String valueMethodName, CellProcessor next) {
        this(type, false, valueMethodName, next);
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, boolean ignoreCase) {
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.enumValueMap = this.createEnumMap(type, ignoreCase);
        this.valueMethod = null;
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, boolean ignoreCase, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.enumValueMap = this.createEnumMap(type, ignoreCase);
        this.valueMethod = null;
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, boolean ignoreCase, String valueMethodName) {
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.enumValueMap = this.createEnumMap(type, ignoreCase, valueMethodName);
        this.valueMethod = this.getEnumValueMethod(type, valueMethodName);
    }

    public <T extends Enum<T>> ParseEnum(Class<T> type, boolean ignoreCase, String valueMethodName, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.enumValueMap = this.createEnumMap(type, ignoreCase, valueMethodName);
        this.valueMethod = this.getEnumValueMethod(type, valueMethodName);
    }

    protected static void checkPreconditions(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type should be not null");
        }
    }

    protected <T extends Enum<T>> Method getEnumValueMethod(Class<T> enumClass, String valueMethodName) {
        try {
            Method method = enumClass.getMethod(valueMethodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("not found method '%s'", valueMethodName), e);
        }
    }

    protected <T extends Enum<T>> Map<String, Enum<?>> createEnumMap(Class<T> enumClass, boolean ignoreCase) {
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : set) {
            String key = ignoreCase ? e.name().toLowerCase() : e.name();
            map.put(key, e);
        }
        return Collections.unmodifiableMap(map);
    }

    protected <T extends Enum<T>> Map<String, Enum<?>> createEnumMap(Class<T> enumClass, boolean ignoreCase, String methodName) {
        Method method = this.getEnumValueMethod(enumClass, methodName);
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        try {
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                String key = ignoreCase ? returnValue.toString().toLowerCase() : returnValue.toString();
                map.put(key, e);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(map);
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String stringValue = this.ignoreCase ? ((String)value).toLowerCase() : (String)value;
        Enum<?> result = this.enumValueMap.get(stringValue);
        if (result == null) {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as an Enum", value), context, (CellProcessor)this);
        }
        return this.next.execute(result, context);
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Map<String, Enum<?>> getEnumValueMap() {
        return this.enumValueMap;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType().getCanonicalName());
        vars.put("valueMethod", this.getValueMethod() == null ? "" : this.getValueMethod().getName());
        vars.put("ignoreCase", this.isIgnoreCase());
        List enumValues = this.getEnumValueMap().entrySet().stream().map(e -> (Enum)e.getValue()).collect(Collectors.toList());
        String enumsStr = this.getEnumValueMap().entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.joining(", "));
        vars.put("enumValues", enumValues);
        vars.put("enumsStr", enumsStr);
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isAssignableFrom(this.type)) {
            Enum enumValue = (Enum)value;
            for (Map.Entry<String, Enum<?>> entry : this.getEnumValueMap().entrySet()) {
                if (!entry.getValue().equals(enumValue)) continue;
                return entry.getKey();
            }
        }
        return value.toString();
    }
}

