/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseBoolean
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected static final String[] DEFAULT_TRUE_VALUES = new String[]{"true", "1", "yes", "on", "y", "t"};
    protected static final String[] DEFAULT_FALSE_VALUES = new String[]{"false", "0", "no", "off", "f", "n"};
    protected final Set<String> trueValues;
    protected final Set<String> falseValues;
    protected final boolean ignoreCase;
    protected boolean failToFalse;

    public ParseBoolean() {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, false);
    }

    public ParseBoolean(BoolCellProcessor next) {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, false, next);
    }

    public ParseBoolean(boolean ignoreCase) {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, ignoreCase);
    }

    public ParseBoolean(boolean ignoreCase, BoolCellProcessor next) {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, ignoreCase, next);
    }

    public ParseBoolean(String[] trueValues, String[] falseValues) {
        this(trueValues, falseValues, false);
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, boolean ignoreCase) {
        ParseBoolean.checkPreconditions(trueValues, falseValues);
        this.trueValues = this.createBooleanValuesSet(trueValues);
        this.falseValues = this.createBooleanValuesSet(falseValues);
        this.ignoreCase = ignoreCase;
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, BoolCellProcessor next) {
        this(trueValues, falseValues, false, next);
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, boolean ignoreCase, BoolCellProcessor next) {
        super((CellProcessor)next);
        ParseBoolean.checkPreconditions(trueValues, falseValues);
        this.trueValues = this.createBooleanValuesSet(trueValues);
        this.falseValues = this.createBooleanValuesSet(falseValues);
        this.ignoreCase = ignoreCase;
    }

    private Set<String> createBooleanValuesSet(String[] values) {
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, values);
        return Collections.unmodifiableSet(set);
    }

    protected static void checkPreconditions(String[] trueValues, String[] falseValues) {
        if (trueValues == null) {
            throw new NullPointerException("trueValues should not be null");
        }
        if (trueValues.length == 0) {
            throw new IllegalArgumentException("trueValues should not be empty");
        }
        if (falseValues == null) {
            throw new NullPointerException("falseValues should not be null");
        }
        if (falseValues.length == 0) {
            throw new IllegalArgumentException("falseValues should not be empty");
        }
    }

    public Object execute(Object value, CsvContext context) {
        Boolean result;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String stringValue = (String)value;
        if (ParseBoolean.contains(this.trueValues, stringValue, this.ignoreCase)) {
            result = Boolean.TRUE;
        } else if (ParseBoolean.contains(this.falseValues, stringValue, this.ignoreCase)) {
            result = Boolean.FALSE;
        } else if (this.failToFalse) {
            result = Boolean.FALSE;
        } else {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a Boolean", value), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    private static boolean contains(Set<String> set, String value, boolean ignoreCase) {
        if (ignoreCase) {
            for (String element : set) {
                if (!element.equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }
        return set.contains(value);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("trueValues", this.getTrueValues());
        vars.put("trueStr", String.join((CharSequence)", ", this.getTrueValues()));
        vars.put("falseValues", this.getFalseValues());
        vars.put("falseStr", String.join((CharSequence)", ", this.getFalseValues()));
        vars.put("ignoreCase", this.isIgnoreCase());
        vars.put("failToFalse", this.isFailToFalse());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public Set<String> getTrueValues() {
        return this.trueValues;
    }

    public Set<String> getFalseValues() {
        return this.falseValues;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isFailToFalse() {
        return this.failToFalse;
    }

    public ParseBoolean setFailToFalse(boolean failToFalse) {
        this.failToFalse = failToFalse;
        return this;
    }
}

