/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.math.BigInteger;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class ParseBigInteger
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseBigInteger() {
    }

    public ParseBigInteger(CellProcessor next) {
        super(next);
    }

    public Object execute(Object value, CsvContext context) {
        BigInteger result;
        this.validateInputNotNull(value, context);
        if (value instanceof BigInteger) {
            result = (BigInteger)value;
        } else if (value instanceof String) {
            String s = (String)value;
            try {
                result = new BigInteger(s);
            }
            catch (NumberFormatException e) {
                throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as an BigInteger", value), context, (CellProcessor)this, (Throwable)e);
            }
        } else {
            String actualClassName = value.getClass().getName();
            throw new SuperCsvCellProcessorException(String.format("the input value should be of type BigInteger or String but is of type %s", actualClassName), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }
}

