/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.NumberFormatWrapper;
import org.supercsv.util.CsvContext;

public class FormatLocaleNumber
extends CellProcessorAdaptor
implements DoubleCellProcessor,
LongCellProcessor,
ValidationCellProcessor {
    protected final NumberFormatWrapper formatter;

    public FormatLocaleNumber(NumberFormat formatter) {
        FormatLocaleNumber.checkPreconditions(formatter);
        this.formatter = new NumberFormatWrapper(formatter);
    }

    public FormatLocaleNumber(NumberFormat formatter, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatLocaleNumber.checkPreconditions(formatter);
        this.formatter = new NumberFormatWrapper(formatter);
    }

    private static void checkPreconditions(NumberFormat formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Number)) {
            throw new SuperCsvCellProcessorException(Number.class, value, context, (CellProcessor)this);
        }
        String result = this.formatter.format((Number)value);
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap vars = new HashMap();
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return this.formatter.format(number);
        }
        return value.toString();
    }
}

