/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.ext.util.DateFormatWrapper;
import org.supercsv.util.CsvContext;

public class FormatLocaleDate
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    protected final DateFormatWrapper formatter;

    public FormatLocaleDate(DateFormat formatter) {
        FormatLocaleDate.checkPreconditions(formatter);
        this.formatter = new DateFormatWrapper(formatter);
    }

    public FormatLocaleDate(DateFormat formatter, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatLocaleDate.checkPreconditions(formatter);
        this.formatter = new DateFormatWrapper(formatter);
    }

    private static void checkPreconditions(DateFormat formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Date)) {
            throw new SuperCsvCellProcessorException(Date.class, value, context, (CellProcessor)this);
        }
        String result = this.formatter.format((Date)value);
        return this.next.execute((Object)result, context);
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap vars = new HashMap();
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this.formatter.format(date);
        }
        return value.toString();
    }
}

