/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.time;

import java.lang.annotation.Annotation;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.time.FmtZoneId;
import org.supercsv.cellprocessor.time.ParseZoneId;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class ZoneIdCellProcessorBuilder
extends AbstractCellProcessorBuilder<ZoneId> {
    @Override
    public CellProcessor buildOutputCellProcessor(Class<ZoneId> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CellProcessor cp = processor;
        cp = cp == null ? new FmtZoneId() : new FmtZoneId(cp);
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<ZoneId> type, Annotation[] annos, CellProcessor processor) {
        CellProcessor cp = processor;
        cp = cp == null ? new ParseZoneId() : new ParseZoneId(cp);
        return cp;
    }

    @Override
    public Optional<ZoneId> parseValue(Class<ZoneId> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        try {
            return Optional.of(ZoneId.of(strValue));
        }
        catch (DateTimeException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to ZoneId.", strValue), e);
        }
    }
}

