/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.time;

import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.time.FmtLocalDate;
import org.supercsv.cellprocessor.time.ParseLocalDate;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.time.AbstractTemporalAccessorCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class LocalDateCellProcessorBuilder
extends AbstractTemporalAccessorCellProcessorBuilder<LocalDate> {
    @Override
    protected String getDefaultPattern() {
        return "uuuu-MM-dd";
    }

    @Override
    public Optional<LocalDate> parseValue(Class<LocalDate> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        String pattern = this.getPattern(converterAnno);
        try {
            return Optional.of(LocalDate.parse(strValue, formatter));
        }
        catch (DateTimeParseException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to LocalDate with pattern '%s'", strValue, pattern), e);
        }
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<LocalDate> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalDate> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalDate> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        FmtLocalDate fmtLocalDate = cp = cp == null ? new FmtLocalDate(formatter) : new FmtLocalDate(formatter, cp);
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<LocalDate> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateTimeFormatter formatter = this.createDateTimeFormatter(converterAnno);
        Optional<LocalDate> min = this.getMin(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        Optional<LocalDate> max = this.getMax(converterAnno).map(s -> this.parseValue(type, annos, (String)s).get());
        CellProcessor cp = processor;
        cp = (cp = this.prependRangeProcessor(type, annos, cp, min, max)) == null ? new ParseLocalDate(formatter) : new ParseLocalDate(formatter, cp);
        return cp;
    }
}

