/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.joda;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.joda.time.Interval;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.joda.FmtInterval;
import org.supercsv.cellprocessor.joda.ParseInterval;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class IntervalCellProcessorBuilder
extends AbstractCellProcessorBuilder<Interval> {
    @Override
    public CellProcessor buildOutputCellProcessor(Class<Interval> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CellProcessor cp = processor;
        cp = cp == null ? new FmtInterval() : new FmtInterval(cp);
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Interval> type, Annotation[] annos, CellProcessor processor) {
        CellProcessor cp = processor;
        cp = cp == null ? new ParseInterval() : new ParseInterval(cp);
        return cp;
    }

    @Override
    public Optional<Interval> parseValue(Class<Interval> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Interval.parse((String)strValue));
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvInvalidAnnotationException(String.format("default '%s' value cannot parse to Interval.", strValue), e);
        }
    }
}

