/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.supercsv.cellprocessor.constraint.ForbidSubStr;
import org.supercsv.cellprocessor.constraint.RequireSubStr;
import org.supercsv.cellprocessor.constraint.StrNotNullOrEmpty;
import org.supercsv.cellprocessor.constraint.StrRegEx;
import org.supercsv.cellprocessor.constraint.Strlen;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.annotation.CsvStringConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.constraint.Length;
import org.supercsv.ext.cellprocessor.constraint.MaxLength;
import org.supercsv.ext.cellprocessor.constraint.MinLength;
import org.supercsv.ext.util.Utils;

public class StringCellProcessorBuilder
extends AbstractCellProcessorBuilder<String> {
    public static final String CONVERT_NULL_STRING_EMPTY = "@empty";

    protected Optional<CsvStringConverter> getStringConverterAnnotation(Annotation[] annos) {
        return StringCellProcessorBuilder.getAnnotation(annos, CsvStringConverter.class);
    }

    protected Optional<Integer> getMinLength(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.minLength()).filter(n -> n >= 0);
    }

    protected Optional<Integer> getMaxLength(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.maxLength()).filter(n -> n >= 0);
    }

    protected int[] getExactLength(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.exactLength()).orElse(new int[0]);
    }

    protected Optional<String> getRegex(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.regex()).filter(s -> s.length() > 0);
    }

    protected String[] getForbid(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.forbid()).orElse(new String[0]);
    }

    protected String[] getContain(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.contain()).orElse(new String[0]);
    }

    protected boolean getNotEmpty(Optional<CsvStringConverter> converterAnno) {
        return converterAnno.map(a -> a.notEmpty()).orElse(false);
    }

    @Override
    protected CellProcessor buildOutputCellProcessorWithConvertNullTo(Class<String> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor, CsvColumn csvColumnAnno) {
        if (!csvColumnAnno.outputDefaultValue().isEmpty()) {
            Optional<String> defaultValue = this.parseValue(type, annos, csvColumnAnno.outputDefaultValue());
            return this.prependConvertNullToProcessor(type, annos, processor, defaultValue.get());
        }
        return processor;
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<String> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvStringConverter> converterAnno = this.getStringConverterAnnotation(annos);
        Optional<Integer> minLength = this.getMinLength(converterAnno);
        Optional<Integer> maxLength = this.getMaxLength(converterAnno);
        int[] exactLength = this.getExactLength(converterAnno);
        Optional<String> regex = this.getRegex(converterAnno);
        String[] forbid = this.getForbid(converterAnno);
        String[] contain = this.getContain(converterAnno);
        boolean notEmpty = this.getNotEmpty(converterAnno);
        CellProcessor cp = processor;
        if (!ignoreValidationProcessor) {
            cp = this.prependForbidProcessor(cp, forbid);
            cp = this.prependContainProcessor(cp, contain);
            cp = this.prependRegExProcessor(cp, regex);
            cp = this.prependLengthProcessor(cp, minLength, maxLength, exactLength);
            cp = this.prependNotEmptyProcessor(cp, notEmpty);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<String> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvStringConverter> converterAnno = this.getStringConverterAnnotation(annos);
        Optional<Integer> minLength = this.getMinLength(converterAnno);
        Optional<Integer> maxLength = this.getMaxLength(converterAnno);
        int[] exactLength = this.getExactLength(converterAnno);
        Optional<String> regex = this.getRegex(converterAnno);
        String[] forbid = this.getForbid(converterAnno);
        String[] contain = this.getContain(converterAnno);
        boolean notEmpty = this.getNotEmpty(converterAnno);
        CellProcessor cp = processor;
        cp = this.prependForbidProcessor(cp, forbid);
        cp = this.prependContainProcessor(cp, contain);
        cp = this.prependRegExProcessor(cp, regex);
        cp = this.prependLengthProcessor(cp, minLength, maxLength, exactLength);
        cp = this.prependNotEmptyProcessor(cp, notEmpty);
        return cp;
    }

    protected CellProcessor prependLengthProcessor(CellProcessor processor, Optional<Integer> minLength, Optional<Integer> maxLength, int[] exactLength) {
        if (minLength.isPresent() && maxLength.isPresent()) {
            return processor == null ? new Length(minLength.get(), maxLength.get()) : new Length(minLength.get(), maxLength.get(), processor);
        }
        if (minLength.isPresent()) {
            return processor == null ? new MinLength(minLength.get()) : new MinLength(minLength.get(), processor);
        }
        if (maxLength.isPresent()) {
            return processor == null ? new MaxLength(maxLength.get()) : new MaxLength(maxLength.get(), processor);
        }
        if (exactLength.length > 0) {
            return processor == null ? new Strlen(exactLength) : new Strlen(exactLength, processor);
        }
        return processor;
    }

    protected CellProcessor prependRegExProcessor(CellProcessor cellProcessor, Optional<String> regex) {
        if (regex.isPresent()) {
            return cellProcessor == null ? new StrRegEx(regex.get()) : new StrRegEx(regex.get(), (StringCellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    protected CellProcessor prependForbidProcessor(CellProcessor cellProcessor, String[] forbid) {
        if (forbid.length == 0) {
            return cellProcessor;
        }
        return cellProcessor == null ? new ForbidSubStr(forbid) : new ForbidSubStr(forbid, (CellProcessor)((StringCellProcessor)cellProcessor));
    }

    protected CellProcessor prependContainProcessor(CellProcessor cellProcessor, String[] contains) {
        if (contains.length == 0) {
            return cellProcessor;
        }
        return cellProcessor == null ? new RequireSubStr(contains) : new RequireSubStr(contains, (CellProcessor)((StringCellProcessor)cellProcessor));
    }

    protected CellProcessor prependNotEmptyProcessor(CellProcessor processor, boolean notEmpty) {
        if (!notEmpty) {
            return processor;
        }
        return processor == null ? new StrNotNullOrEmpty() : new StrNotNullOrEmpty((CellProcessor)((StringCellProcessor)processor));
    }

    @Override
    public Optional<String> parseValue(Class<String> type, Annotation[] annos, String strValue) {
        if (Utils.isEmpty(strValue)) {
            return Optional.empty();
        }
        if (strValue.equals(CONVERT_NULL_STRING_EMPTY)) {
            return Optional.of("");
        }
        return Optional.of(strValue);
    }
}

