/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.annotation.CsvNumberConverter;
import org.supercsv.ext.builder.impl.AbstractNumberCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatLocaleNumber;
import org.supercsv.ext.cellprocessor.ParseFloat;
import org.supercsv.ext.cellprocessor.ParseLocaleNumber;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class FloatCellProcessorBuilder
extends AbstractNumberCellProcessorBuilder<Float> {
    @Override
    protected CellProcessor buildInputCellProcessorWithConvertNullTo(Class<Float> type, Annotation[] annos, CellProcessor cellProcessor, CsvColumn csvColumnAnno) {
        if (type.isPrimitive() && csvColumnAnno.optional() && csvColumnAnno.inputDefaultValue().isEmpty()) {
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, Float.valueOf(0.0f));
        }
        if (!csvColumnAnno.inputDefaultValue().isEmpty()) {
            Optional<Float> value = this.parseValue(type, annos, csvColumnAnno.inputDefaultValue());
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, value.get());
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Float> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<Float> min = this.getMin(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Optional<Float> max = this.getMax(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Object cp = processor;
        if (formatter.isPresent()) {
            FormatLocaleNumber formatLocaleNumber = cp = cp == null ? new FormatLocaleNumber(formatter.get()) : new FormatLocaleNumber(formatter.get(), (StringCellProcessor)cp);
        }
        if (!ignoreValidationProcessor) {
            cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        }
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Float> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Optional<Float> min = this.getMin(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Optional<Float> max = this.getMax(converterAnno).map(n -> this.parseValue(type, annos, (String)n).get());
        Object cp = processor;
        cp = this.prependRangeProcessor(type, annos, (CellProcessor)cp, min, max);
        cp = formatter.isPresent() ? (cp == null ? new ParseLocaleNumber<Float>(type, formatter.get(), lenient) : new ParseLocaleNumber<Float>(type, formatter.get(), lenient, (CellProcessor)cp)) : (cp == null ? new ParseFloat() : new ParseFloat((DoubleCellProcessor)cp));
        return cp;
    }

    @Override
    public Optional<Float> parseValue(Class<Float> type, Annotation[] annos, String strValue) {
        if (strValue.isEmpty()) {
            return Optional.empty();
        }
        Optional<CsvNumberConverter> converterAnno = this.getNumberConverterAnnotation(annos);
        Optional<NumberFormat> formatter = this.createNumberFormatter(converterAnno);
        Optional<String> pattern = this.getPattern(converterAnno);
        if (formatter.isPresent()) {
            try {
                return Optional.of(Float.valueOf(formatter.get().parse(strValue).floatValue()));
            }
            catch (ParseException e) {
                throw new SuperCsvInvalidAnnotationException(String.format(" value '%s' cannot parse to Number with pattern '%s'", strValue, pattern), e);
            }
        }
        return Optional.of(Float.valueOf(strValue));
    }
}

