/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.supercsv.cellprocessor.FmtBool;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvBooleanConverter;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.ParseBoolean;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public class BooleanCellProcessorBuilder
extends AbstractCellProcessorBuilder<Boolean> {
    @Override
    protected CellProcessor buildInputCellProcessorWithConvertNullTo(Class<Boolean> type, Annotation[] annos, CellProcessor cellProcessor, CsvColumn csvColumnAnno) {
        if (type.isPrimitive() && csvColumnAnno.optional() && csvColumnAnno.inputDefaultValue().isEmpty()) {
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, false);
        }
        if (!csvColumnAnno.inputDefaultValue().isEmpty()) {
            Optional<Boolean> value = this.parseValue(type, annos, csvColumnAnno.inputDefaultValue());
            return this.prependConvertNullToProcessor(type, annos, cellProcessor, value.get());
        }
        return cellProcessor;
    }

    protected Optional<CsvBooleanConverter> getBooleanConverterAnnotation(Annotation[] annos) {
        return BooleanCellProcessorBuilder.getAnnotation(annos, CsvBooleanConverter.class);
    }

    protected String getOutputTrueValue(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.outputTrueValue()).orElse("true");
    }

    protected String getOutputFalseValue(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.outputFalseValue()).orElse("false");
    }

    protected String[] getInputTrueValue(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.inputTrueValue()).orElse(new String[]{"true", "1", "yes", "on", "y", "t"});
    }

    protected String[] getInputFalseValue(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.inputFalseValue()).orElse(new String[]{"false", "0", "no", "off", "f", "n"});
    }

    protected boolean getIgnoreCase(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.ignoreCase()).orElse(false);
    }

    protected boolean getFailToFalse(Optional<CsvBooleanConverter> converterAnno) {
        return converterAnno.map(a -> a.failToFalse()).orElse(false);
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Boolean> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        Optional<CsvBooleanConverter> converterAnno = this.getBooleanConverterAnnotation(annos);
        String trueValue = this.getOutputTrueValue(converterAnno);
        String falseValue = this.getOutputFalseValue(converterAnno);
        CellProcessor cp = processor;
        cp = cp == null ? new FmtBool(trueValue, falseValue) : new FmtBool(trueValue, falseValue, (StringCellProcessor)cp);
        return cp;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Boolean> type, Annotation[] annos, CellProcessor processor) {
        Optional<CsvBooleanConverter> converterAnno = this.getBooleanConverterAnnotation(annos);
        String[] trueValue = this.getInputTrueValue(converterAnno);
        String[] falseValue = this.getInputFalseValue(converterAnno);
        boolean ignoreCase = this.getIgnoreCase(converterAnno);
        boolean failToFalse = this.getFailToFalse(converterAnno);
        Object cp = processor;
        cp = cp == null ? new ParseBoolean(trueValue, falseValue, ignoreCase).setFailToFalse(failToFalse) : new ParseBoolean(trueValue, falseValue, ignoreCase, (BoolCellProcessor)cp).setFailToFalse(failToFalse);
        return cp;
    }

    @Override
    public Optional<Boolean> parseValue(Class<Boolean> type, Annotation[] annos, String strValue) {
        Optional<CsvBooleanConverter> converterAnno = this.getBooleanConverterAnnotation(annos);
        String[] trueValue = this.getInputTrueValue(converterAnno);
        String[] falseValue = this.getInputFalseValue(converterAnno);
        boolean ignoreCase = this.getIgnoreCase(converterAnno);
        boolean failToFalse = this.getFailToFalse(converterAnno);
        for (String trueStr : trueValue) {
            if (ignoreCase && trueStr.equalsIgnoreCase(strValue)) {
                return Optional.of(Boolean.TRUE);
            }
            if (ignoreCase || !trueStr.equals(strValue)) continue;
            return Optional.of(Boolean.TRUE);
        }
        for (String falseStr : falseValue) {
            if (ignoreCase && falseStr.equalsIgnoreCase(strValue)) {
                return Optional.of(Boolean.FALSE);
            }
            if (ignoreCase || !falseStr.equals(strValue)) continue;
            return Optional.of(Boolean.FALSE);
        }
        if (Utils.isEmpty(strValue) && type.isAssignableFrom(Boolean.class)) {
            return Optional.empty();
        }
        if (failToFalse) {
            return Optional.of(Boolean.FALSE);
        }
        throw new SuperCsvInvalidAnnotationException(String.format("defaultValue '%s' cannot parse.", strValue));
    }
}

