/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvNumberConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.constraint.Max;
import org.supercsv.ext.cellprocessor.constraint.Min;
import org.supercsv.ext.cellprocessor.constraint.Range;
import org.supercsv.ext.util.Utils;

public abstract class AbstractNumberCellProcessorBuilder<N extends Number>
extends AbstractCellProcessorBuilder<N> {
    protected Optional<CsvNumberConverter> getNumberConverterAnnotation(Annotation[] annos) {
        return AbstractNumberCellProcessorBuilder.getAnnotation(annos, CsvNumberConverter.class);
    }

    protected Optional<String> getPattern(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.pattern()).filter(s -> s.length() > 0);
    }

    protected boolean getLenient(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.lenient()).orElse(true);
    }

    protected Locale getLocale(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> Utils.getLocale(a.locale())).orElse(Locale.getDefault());
    }

    protected Optional<Currency> getCurrency(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.currency()).filter(s -> s.length() > 0).map(s -> Currency.getInstance(s));
    }

    protected Optional<RoundingMode> getRounding(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.rounding());
    }

    protected Optional<String> getMin(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.min()).filter(s -> s.length() > 0);
    }

    protected Optional<String> getMax(Optional<CsvNumberConverter> converterAnno) {
        return converterAnno.map(a -> a.max()).filter(s -> s.length() > 0);
    }

    protected CellProcessor prependRangeProcessor(Class<N> type, Annotation[] annos, CellProcessor cellProcessor, Optional<N> min, Optional<N> max) {
        Optional<NumberFormat> formatter = this.createNumberFormatter(this.getNumberConverterAnnotation(annos));
        if (min.isPresent() && max.isPresent()) {
            Range<Number> cp = cellProcessor == null ? new Range<Number>((Number)min.get(), (Number)max.get()) : new Range<Number>((Number)min.get(), (Number)max.get(), cellProcessor);
            formatter.ifPresent(f -> cp.setFormatter((NumberFormat)f));
            return cp;
        }
        if (min.isPresent()) {
            Min<Number> cp = cellProcessor == null ? new Min<Number>((Number)min.get()) : new Min<Number>((Number)min.get(), cellProcessor);
            formatter.ifPresent(f -> cp.setFormatter((NumberFormat)f));
            return cp;
        }
        if (max.isPresent()) {
            Max<Number> cp = cellProcessor == null ? new Max<Number>((Number)max.get()) : new Max<Number>((Number)max.get(), cellProcessor);
            formatter.ifPresent(f -> cp.setFormatter((NumberFormat)f));
            return cp;
        }
        return cellProcessor;
    }

    protected Optional<NumberFormat> createNumberFormatter(Optional<CsvNumberConverter> converterAnno) {
        Optional<String> pattern = this.getPattern(converterAnno);
        if (!pattern.isPresent()) {
            return Optional.empty();
        }
        Locale locale = this.getLocale(converterAnno);
        Optional<Currency> currency = this.getCurrency(converterAnno);
        Optional<RoundingMode> roundingMode = this.getRounding(converterAnno);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        DecimalFormat formatter = new DecimalFormat(pattern.get(), symbols);
        formatter.setParseBigDecimal(true);
        roundingMode.ifPresent(r -> formatter.setRoundingMode((RoundingMode)((Object)r)));
        currency.ifPresent(c -> formatter.setCurrency((Currency)c));
        return Optional.of(formatter);
    }
}

