/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder.impl;

import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.ext.annotation.CsvDateConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.constraint.DateRange;
import org.supercsv.ext.cellprocessor.constraint.FutureDate;
import org.supercsv.ext.cellprocessor.constraint.PastDate;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;
import org.supercsv.ext.util.Utils;

public abstract class AbstractDateCellProcessorBuilder<T extends Date>
extends AbstractCellProcessorBuilder<T> {
    protected Optional<CsvDateConverter> getDateConverterAnnotation(Annotation[] annos) {
        return AbstractDateCellProcessorBuilder.getAnnotation(annos, CsvDateConverter.class);
    }

    protected String getPattern(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.pattern()).filter(s -> s.length() > 0).orElse(this.getDefaultPattern());
    }

    protected boolean getLenient(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.lenient()).orElse(true);
    }

    protected Locale getLocale(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> Utils.getLocale(a.locale())).orElse(Locale.getDefault());
    }

    protected TimeZone getTimeZone(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.timezone()).filter(s -> s.length() > 0).map(s -> TimeZone.getTimeZone(s)).orElse(TimeZone.getDefault());
    }

    protected Optional<String> getMin(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.min()).filter(s -> s.length() > 0);
    }

    protected Optional<String> getMax(Optional<CsvDateConverter> converterAnno) {
        return converterAnno.map(a -> a.max()).filter(s -> s.length() > 0);
    }

    protected CellProcessor prependRangeProcessor(Class<T> type, Annotation[] annos, CellProcessor cellProcessor, Optional<T> min, Optional<T> max) {
        DateFormat formatter = this.createDateFormatter(this.getDateConverterAnnotation(annos));
        if (min.isPresent() && max.isPresent()) {
            DateRange<Date> cp = cellProcessor == null ? new DateRange<Date>((Date)min.get(), (Date)max.get()) : new DateRange<Date>((Date)min.get(), (Date)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (min.isPresent()) {
            FutureDate<Date> cp = cellProcessor == null ? new FutureDate<Date>((Date)min.get()) : new FutureDate<Date>((Date)min.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        if (max.isPresent()) {
            PastDate<Date> cp = cellProcessor == null ? new PastDate<Date>((Date)max.get()) : new PastDate<Date>((Date)max.get(), cellProcessor);
            cp.setFormatter(formatter);
            return cp;
        }
        return cellProcessor;
    }

    protected abstract String getDefaultPattern();

    protected DateFormat createDateFormatter(Optional<CsvDateConverter> converterAnno) {
        String pattern = this.getPattern(converterAnno);
        boolean lenient = this.getLenient(converterAnno);
        Locale locale = this.getLocale(converterAnno);
        TimeZone timeZone = this.getTimeZone(converterAnno);
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        formatter.setLenient(lenient);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    protected Optional<Date> parseDate(Annotation[] annos, String strValue) {
        if (strValue.isEmpty()) {
            return Optional.empty();
        }
        Optional<CsvDateConverter> converterAnno = this.getDateConverterAnnotation(annos);
        DateFormat formatter = this.createDateFormatter(converterAnno);
        String pattern = this.getPattern(converterAnno);
        try {
            return Optional.of(formatter.parse(strValue));
        }
        catch (ParseException e) {
            throw new SuperCsvInvalidAnnotationException(String.format(" default '%s' value cannot parse to Date with pattern '%s'", strValue, pattern), e);
        }
    }
}

