/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.localization;

import java.util.ArrayList;
import java.util.List;
import org.supercsv.ext.localization.CsvMessage;
import org.supercsv.ext.localization.MapVariableInterpolator;
import org.supercsv.ext.localization.MessageResolver;
import org.supercsv.ext.localization.ResourceBundleMessageResolver;

public class CsvMessageConverter {
    private MessageResolver messageResolver;

    public CsvMessageConverter() {
        this.messageResolver = new ResourceBundleMessageResolver();
    }

    public CsvMessageConverter(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public String convertMessage(CsvMessage error) {
        if (error == null) {
            throw new NullPointerException("error should not be null.");
        }
        String msg = this.messageResolver.getMessage(error.getCode());
        return MapVariableInterpolator.interpolate(msg, error.getVariables());
    }

    public List<String> convertMessage(List<CsvMessage> errors) {
        if (errors == null) {
            throw new NullPointerException("errors should not be null.");
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (CsvMessage error : errors) {
            messages.add(this.convertMessage(error));
        }
        return messages;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }
}

