/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class ParseShort
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseShort() {
    }

    public ParseShort(LongCellProcessor next) {
        super((CellProcessor)next);
    }

    public Object execute(Object value, CsvContext context) {
        Short result;
        this.validateInputNotNull(value, context);
        if (value instanceof Short) {
            result = (Short)value;
        } else if (value instanceof String) {
            try {
                result = Short.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as an Short", value), context, (CellProcessor)this, (Throwable)e);
            }
        } else {
            String actualClassName = value.getClass().getName();
            throw new SuperCsvCellProcessorException(String.format("the input value should be of type Short or String but is of type %s", actualClassName), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }
}

