/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.Utils;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseBoolean
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected static final String[] DEFAULT_TRUE_VALUES = new String[]{"true", "1", "yes", "on", "y", "t"};
    protected static final String[] DEFAULT_FALSE_VALUES = new String[]{"false", "0", "no", "off", "f", "n"};
    protected final Set<String> trueValues;
    protected final Set<String> falseValues;
    protected final boolean lenient;
    protected boolean failToFalse;

    public ParseBoolean() {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, false);
    }

    public ParseBoolean(boolean lenient) {
        this(DEFAULT_TRUE_VALUES, DEFAULT_FALSE_VALUES, lenient);
    }

    public ParseBoolean(String trueValue, String falseValue) {
        this(trueValue, falseValue, false);
    }

    public ParseBoolean(String trueValue, String falseValue, boolean lenient) {
        ParseBoolean.checkPreconditions(trueValue, falseValue);
        this.trueValues = this.createBooleanValuesSet(trueValue, lenient);
        this.falseValues = this.createBooleanValuesSet(falseValue, lenient);
        this.lenient = lenient;
    }

    public ParseBoolean(String[] trueValues, String[] falseValues) {
        this(trueValues, falseValues, false);
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, boolean lenient) {
        ParseBoolean.checkPreconditions(trueValues, falseValues);
        this.trueValues = this.createBooleanValuesSet(trueValues, lenient);
        this.falseValues = this.createBooleanValuesSet(falseValues, lenient);
        this.lenient = lenient;
    }

    public ParseBoolean(String trueValue, String falseValue, BoolCellProcessor next) {
        this(trueValue, falseValue, false, next);
    }

    public ParseBoolean(String trueValue, String falseValue, boolean lenient, BoolCellProcessor next) {
        super((CellProcessor)next);
        ParseBoolean.checkPreconditions(trueValue, falseValue);
        this.trueValues = this.createBooleanValuesSet(trueValue, lenient);
        this.falseValues = this.createBooleanValuesSet(falseValue, lenient);
        this.lenient = lenient;
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, BoolCellProcessor next) {
        this(trueValues, falseValues, false, next);
    }

    public ParseBoolean(String[] trueValues, String[] falseValues, boolean lenient, BoolCellProcessor next) {
        super((CellProcessor)next);
        ParseBoolean.checkPreconditions(trueValues, falseValues);
        this.trueValues = this.createBooleanValuesSet(trueValues, lenient);
        this.falseValues = this.createBooleanValuesSet(falseValues, lenient);
        this.lenient = lenient;
    }

    protected Set<String> createBooleanValuesSet(String value, boolean lenient) {
        return this.createBooleanValuesSet(new String[]{value}, lenient);
    }

    protected Set<String> createBooleanValuesSet(String[] values, boolean lenient) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (lenient) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                set.add(str.toLowerCase());
                ++n2;
            }
        } else {
            Collections.addAll(set, values);
        }
        return Collections.unmodifiableSet(set);
    }

    protected static void checkPreconditions(String trueValue, String falseValue) {
        if (trueValue == null) {
            throw new NullPointerException("trueValue should not be null");
        }
        if (falseValue == null) {
            throw new IllegalArgumentException("falseValue should not be null");
        }
    }

    protected static void checkPreconditions(String[] trueValues, String[] falseValues) {
        if (trueValues == null) {
            throw new NullPointerException("trueValues should not be null");
        }
        if (trueValues.length == 0) {
            throw new IllegalArgumentException("trueValues should not be empty");
        }
        if (falseValues == null) {
            throw new NullPointerException("falseValues should not be null");
        }
        if (falseValues.length == 0) {
            throw new IllegalArgumentException("falseValues should not be empty");
        }
    }

    public Object execute(Object value, CsvContext context) {
        Boolean result;
        String stringValue;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String string = stringValue = this.lenient ? ((String)value).toLowerCase() : (String)value;
        if (this.trueValues.contains(stringValue)) {
            result = Boolean.TRUE;
        } else if (this.falseValues.contains(stringValue)) {
            result = Boolean.FALSE;
        } else if (this.failToFalse) {
            result = Boolean.FALSE;
        } else {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a Boolean", value), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(ParseBoolean.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("trueValues", this.getTrueValues());
        vars.put("trueStr", Utils.join(this.getTrueValues(), ", "));
        vars.put("falseValues", this.getFalseValues());
        vars.put("falseStr", Utils.join(this.getFalseValues(), ", "));
        vars.put("lenient", this.isLenient());
        vars.put("failToFalse", this.isFailToFalse());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public Set<String> getTrueValues() {
        return this.trueValues;
    }

    public Set<String> getFalseValues() {
        return this.falseValues;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public boolean isFailToFalse() {
        return this.failToFalse;
    }

    public ParseBoolean setFailToFalse(boolean failToFalse) {
        this.failToFalse = failToFalse;
        return this;
    }
}

