/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.Utils;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class FormatEnum
extends CellProcessorAdaptor
implements ValidationCellProcessor {
    protected final Class type;
    protected final Map<Enum, String> enumValueMap;
    protected final Method valueMethod;

    public FormatEnum(Class type) {
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type);
        this.valueMethod = null;
    }

    public FormatEnum(Class type, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type);
        this.valueMethod = null;
    }

    public FormatEnum(Class type, String valueMethodName) {
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type, valueMethodName);
        this.valueMethod = this.createEnumValueMethod(type, valueMethodName);
    }

    public FormatEnum(Class type, String valueMethodName, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatEnum.checkPreconditions(type);
        this.type = type;
        this.enumValueMap = this.createEnumMap(type, valueMethodName);
        this.valueMethod = this.createEnumValueMethod(type, valueMethodName);
    }

    protected static void checkPreconditions(Class type) {
        if (type == null) {
            throw new NullPointerException("type should be not null");
        }
        if (!Enum.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("type should be Enum class : %s", type.getCanonicalName()));
        }
    }

    protected Method createEnumValueMethod(Class enumClass, String valueMethodName) {
        try {
            return enumClass.getMethod(valueMethodName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("not found method '%s'", valueMethodName), e);
        }
    }

    protected Map<Enum, String> createEnumMap(Class enumClass) {
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        for (Enum e : set) {
            map.put(e, e.name());
        }
        return Collections.unmodifiableMap(map);
    }

    protected Map<Enum, String> createEnumMap(Class enumClass, String methodName) {
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        try {
            Method method = this.createEnumValueMethod(enumClass, methodName);
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                map.put(e, returnValue.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(map);
    }

    public Object execute(Object value, CsvContext context) {
        String result;
        this.validateInputNotNull(value, context);
        if (value instanceof Enum && value.getClass().isAssignableFrom(this.type)) {
            result = this.getEnumValueMap().get((Enum)value);
            if (result == null) {
                throw new SuperCsvCellProcessorException(String.format("'%s' could not be format as an Enum", value), context, (CellProcessor)this);
            }
        } else {
            String actualClassName = value.getClass().getName();
            throw new SuperCsvCellProcessorException(String.format("the input value should be of type Enum or String but is of type %s", actualClassName), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Map<Enum, String> getEnumValueMap() {
        return this.enumValueMap;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(FormatEnum.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType().getCanonicalName());
        vars.put("valueMethod", this.getValueMethod() == null ? "" : this.getValueMethod().getName());
        ArrayList<String> enumValues = new ArrayList<String>();
        for (Map.Entry<Enum, String> entry : this.getEnumValueMap().entrySet()) {
            enumValues.add(entry.getKey().name());
        }
        vars.put("enumValues", enumValues);
        vars.put("enumsStr", Utils.join(enumValues, ", "));
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

