/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.supercsv.ext.annotation.CsvBean;
import org.supercsv.ext.annotation.CsvColumn;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.builder.CellProcessorBuilderContainer;
import org.supercsv.ext.builder.CellProcessorBuilderFactory;
import org.supercsv.ext.builder.CsvBeanMapping;
import org.supercsv.ext.builder.CsvColumnMapping;
import org.supercsv.ext.builder.DefaultCellProcessorBuilder;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class CsvAnnotationBeanParser {
    private CellProcessorBuilderContainer builderContainer = new CellProcessorBuilderContainer();
    private CellProcessorBuilderFactory builderFactory = new CellProcessorBuilderFactory(){

        @Override
        public <T extends CellProcessorBuilder<?>> T create(Class<T> builderClass) throws Exception {
            return (T)((CellProcessorBuilder)builderClass.newInstance());
        }
    };

    public <T> CsvBeanMapping<T> parse(Class<T> clazz) {
        return this.parse(clazz, false);
    }

    public <T> CsvBeanMapping<T> parse(Class<T> clazz, boolean ignoreValidationProcessorOnOutput) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be not null.");
        }
        CsvBeanMapping<T> mappingBean = new CsvBeanMapping<T>(clazz);
        CsvBean csvBeanAnno = clazz.getAnnotation(CsvBean.class);
        if (csvBeanAnno == null) {
            throw new SuperCsvInvalidAnnotationException("not found annotation 'CsvBean'");
        }
        mappingBean.setHeader(csvBeanAnno.header());
        ArrayList<CsvColumnMapping> mappingColumns = new ArrayList<CsvColumnMapping>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            CsvColumn csvColumnAnno = field.getAnnotation(CsvColumn.class);
            if (csvColumnAnno != null) {
                mappingColumns.add(this.createColumnMapping(field, csvColumnAnno, ignoreValidationProcessorOnOutput));
            }
            ++n2;
        }
        Collections.sort(mappingColumns, new Comparator<CsvColumnMapping>(){

            @Override
            public int compare(CsvColumnMapping o1, CsvColumnMapping o2) {
                if (o1.getPosition() > o2.getPosition()) {
                    return 1;
                }
                if (o1.getPosition() == o2.getPosition()) {
                    return o1.getColumnName().compareTo(o2.getColumnName());
                }
                return -1;
            }
        });
        this.validatePosition(mappingColumns);
        mappingBean.setColumns(mappingColumns);
        return mappingBean;
    }

    private void validatePosition(List<CsvColumnMapping> columns) {
        if (columns.isEmpty()) {
            throw new SuperCsvInvalidAnnotationException("not found column definition.");
        }
        TreeSet<Integer> checkedPosiiton = new TreeSet<Integer>();
        TreeSet<Integer> duplicatePosition = new TreeSet<Integer>();
        for (CsvColumnMapping columnMapping : columns) {
            if (checkedPosiiton.contains(columnMapping.getPosition())) {
                duplicatePosition.add(columnMapping.getPosition());
            }
            checkedPosiiton.add(columnMapping.getPosition());
        }
        TreeSet<Integer> lackPosition = new TreeSet<Integer>();
        int maxPosition = columns.get(columns.size() - 1).getPosition();
        int i = 0;
        while (i < maxPosition) {
            if (!checkedPosiiton.contains(i)) {
                lackPosition.add(i);
            }
            ++i;
        }
        if (!lackPosition.isEmpty() || !duplicatePosition.isEmpty()) {
            throw new SuperCsvInvalidAnnotationException(String.format("position value is wrong. lacked position=%s, duplicated position=%s", lackPosition, duplicatePosition));
        }
    }

    private CsvColumnMapping createColumnMapping(Field field, CsvColumn csvColumnAnno, boolean ignoreValidationProcessorOnOutput) {
        CsvColumnMapping columnMapping = new CsvColumnMapping();
        columnMapping.setColumnName(field.getName());
        columnMapping.setColumnType(field.getType());
        columnMapping.setPosition(csvColumnAnno.position());
        if (csvColumnAnno.label() != null && !csvColumnAnno.label().isEmpty()) {
            columnMapping.setLabel(csvColumnAnno.label());
        } else {
            columnMapping.setLabel(field.getName());
        }
        CellProcessorBuilder<?> builder = null;
        if (csvColumnAnno.builderClass().equals(DefaultCellProcessorBuilder.class)) {
            builder = this.builderContainer.getBuilder(field.getType());
            if (builder == null && Enum.class.isAssignableFrom(field.getType())) {
                builder = this.builderContainer.getBuilder(Enum.class);
            }
            if (builder == null) {
                builder = DefaultCellProcessorBuilder.INSTANCE;
            }
        } else {
            try {
                builder = this.builderFactory.create(csvColumnAnno.builderClass());
            }
            catch (Throwable e) {
                throw new SuperCsvInvalidAnnotationException(String.format("fail create instance of %s with 'builderClass' of @CsvColumn property", csvColumnAnno.builderClass().getCanonicalName()), e);
            }
        }
        if (builder == null) {
            throw new SuperCsvInvalidAnnotationException(String.format("not resolve CellProecssorBuilder for field '%s#%s' and type '%s'", field.getDeclaringClass().getName(), field.getName(), field.getType().getClass().getName()));
        }
        columnMapping.setOutputCellProcessor(builder.buildOutputCellProcessor(field.getType(), field.getAnnotations(), ignoreValidationProcessorOnOutput));
        columnMapping.setInputCellProcessor(builder.buildInputCellProcessor(field.getType(), field.getAnnotations()));
        return columnMapping;
    }

    public CellProcessorBuilderContainer getBuilderContainer() {
        return this.builderContainer;
    }

    public void setBuilderContainer(CellProcessorBuilderContainer builderContainer) {
        this.builderContainer = builderContainer;
    }

    public CellProcessorBuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(CellProcessorBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }
}

