/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.FormattedNumber;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class DecimalNumber
extends FormattedNumber {
    protected final int scale;
    protected String integerPart;
    protected String decimalPart;
    protected int permilles;

    public DecimalNumber(double value, int scale, int permilles) {
        super(value);
        this.scale = scale > 0 ? scale : 0;
        this.permilles = permilles > 0 ? permilles : 0;
        this.init();
    }

    public DecimalNumber(double value, int scale) {
        this(value, scale, 0);
    }

    protected void init() {
        if (this.isZero()) {
            this.integerPart = "";
            this.decimalPart = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        if (this.scale > 0) {
            sb.append(".");
        }
        for (int i = 0; i < this.scale; ++i) {
            sb.append("#");
        }
        DecimalFormat format = new DecimalFormat(sb.toString());
        format.setRoundingMode(RoundingMode.HALF_UP);
        double num = Math.abs(this.getValue());
        if (this.getPermilles() > 0) {
            num /= Math.pow(1000.0, this.getPermilles());
        }
        String str = format.format(num);
        this.setupIntegerAndDecimalPart(str);
    }

    protected void setupIntegerAndDecimalPart(String str) {
        int dotIdx = str.indexOf(".");
        if (dotIdx < 0) {
            this.integerPart = str;
            this.decimalPart = "";
        } else {
            this.integerPart = str.substring(0, dotIdx);
            if (this.integerPart.equals("0")) {
                this.integerPart = "";
            }
            this.decimalPart = str.substring(dotIdx + 1);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public String getIntegerPart() {
        return this.integerPart;
    }

    public String getIntegerPart(int digit) {
        int length = this.integerPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        String num = String.valueOf(this.integerPart.charAt(length - digit));
        if (this.isUseSeparator() && digit >= 4 && (digit - 1) % 3 == 0) {
            num = num + ",";
        }
        return num;
    }

    public String getIntegerPartAfter(int digit) {
        int length = this.integerPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        String num = this.integerPart.substring(0, length - digit + 1);
        if (this.isUseSeparator() && digit >= 4) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < num.length(); ++i) {
                char c = num.charAt(i);
                sb.append(c);
                int itemDigit = length - i;
                if (itemDigit < 3 || (itemDigit - 1) % 3 != 0) continue;
                sb.append(",");
            }
            num = sb.toString();
        }
        return num;
    }

    public String getDecimalPart() {
        return this.decimalPart;
    }

    public String getDecimalPart(int digit) {
        int length = this.decimalPart.length();
        if (length < digit || digit <= 0) {
            return "";
        }
        return String.valueOf(this.decimalPart.charAt(digit - 1));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append("-");
        }
        if (this.getIntegerPart().isEmpty()) {
            sb.append("0");
        }
        if (!this.getDecimalPart().isEmpty()) {
            sb.append(".").append(this.getDecimalPart());
        }
        return sb.toString();
    }

    public int getPermilles() {
        return this.permilles;
    }
}

