/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterResolver;
import com.github.mygreen.cellformatter.FormulaEvaluateException;
import com.github.mygreen.cellformatter.POICell;
import com.github.mygreen.cellformatter.POIEvaluatedCell;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class POICellFormatter {
    private FormatterResolver formatterResolver = new FormatterResolver();
    private boolean cache = true;
    private boolean errorCellAsEmpty = false;
    private boolean throwFailEvaluateFormula = false;
    private boolean considerMergedCell = true;

    public String formatAsString(Cell cell) {
        return this.formatAsString(cell, Locale.getDefault());
    }

    public String formatAsString(Cell cell, Locale locale) {
        return this.format(cell, locale).getText();
    }

    public CellFormatResult format(Cell cell) {
        return this.format(cell, Locale.getDefault());
    }

    public CellFormatResult format(Cell cell, Locale locale) {
        if (cell == null) {
            return this.createBlankCellResult();
        }
        Locale runtimeLocale = locale != null ? locale : Locale.getDefault();
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                if (this.isConsiderMergedCell()) {
                    return this.getMergedCellValue(cell, runtimeLocale);
                }
                return this.createBlankCellResult();
            }
            case BOOLEAN: {
                return this.getCellValue(cell, runtimeLocale);
            }
            case STRING: {
                return this.getCellValue(cell, runtimeLocale);
            }
            case NUMERIC: {
                return this.getCellValue(cell, runtimeLocale);
            }
            case FORMULA: {
                return this.getFormulaCellValue(cell, runtimeLocale);
            }
            case ERROR: {
                return this.getErrorCellValue(cell, runtimeLocale);
            }
        }
        CellFormatResult result = new CellFormatResult();
        result.setCellType(FormatCellType.Unknown);
        result.setText("");
        return result;
    }

    private CellFormatResult createBlankCellResult() {
        CellFormatResult result = new CellFormatResult();
        result.setCellType(FormatCellType.Blank);
        result.setText("");
        return result;
    }

    private CellFormatResult getFormulaCellValue(Cell cell, Locale locale) {
        CellType cellType = cell.getCellTypeEnum();
        assert (cellType == CellType.FORMULA);
        Workbook workbook = cell.getSheet().getWorkbook();
        CreationHelper helper = workbook.getCreationHelper();
        FormulaEvaluator evaluator = helper.createFormulaEvaluator();
        try {
            CellValue value = evaluator.evaluate(cell);
            POIEvaluatedCell evaluatedCell = new POIEvaluatedCell(cell, value);
            switch (value.getCellTypeEnum()) {
                case BOOLEAN: {
                    return this.getCellValue(evaluatedCell, locale);
                }
                case STRING: {
                    return this.getCellValue(evaluatedCell, locale);
                }
                case NUMERIC: {
                    return this.getCellValue(evaluatedCell, locale);
                }
                case ERROR: {
                    return this.getErrorCellValue(value.getErrorValue(), locale);
                }
            }
            CellFormatResult result = new CellFormatResult();
            result.setCellType(FormatCellType.Unknown);
            result.setText("");
            return result;
        }
        catch (Exception e) {
            if (this.isThrowFailEvaluateFormula()) {
                throw new FormulaEvaluateException(cell, e);
            }
            return this.getErrorCellValue(cell.getErrorCellValue(), locale);
        }
    }

    private CellFormatResult getErrorCellValue(Cell cell, Locale locale) {
        CellType cellType = cell.getCellTypeEnum();
        assert (cellType == CellType.ERROR);
        return this.getErrorCellValue(cell.getErrorCellValue(), locale);
    }

    private CellFormatResult getErrorCellValue(byte errorValue, Locale locale) {
        FormulaError error = FormulaError.forInt((byte)errorValue);
        CellFormatResult result = new CellFormatResult();
        result.setCellType(FormatCellType.Error);
        result.setValue(error.getCode());
        if (this.isErrorCellAsEmpty()) {
            result.setText("");
        } else {
            result.setText(error.getString());
        }
        return result;
    }

    private CellFormatResult getMergedCellValue(Cell cell, Locale locale) {
        Sheet sheet = cell.getSheet();
        int size = sheet.getNumMergedRegions();
        for (int i = 0; i < size; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            for (int rowIdx = range.getFirstRow(); rowIdx <= range.getLastRow(); ++rowIdx) {
                Row row = sheet.getRow(rowIdx);
                if (row == null) continue;
                for (int colIdx = range.getFirstColumn(); colIdx <= range.getLastColumn(); ++colIdx) {
                    Cell valueCell = row.getCell(colIdx);
                    if (valueCell == null || valueCell.getCellTypeEnum() == CellType.BLANK) continue;
                    return this.format(valueCell, locale);
                }
            }
        }
        return this.createBlankCellResult();
    }

    private CellFormatResult getCellValue(Cell cell, Locale locale) {
        return this.getCellValue(new POICell(cell), locale);
    }

    private CellFormatResult getCellValue(POICell poiCell, Locale locale) {
        short formatIndex = poiCell.getFormatIndex();
        String formatPattern = poiCell.getFormatPattern();
        if (this.formatterResolver.canResolve(formatIndex)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatIndex);
            return cellFormatter.format(poiCell, locale);
        }
        if (this.formatterResolver.canResolve(formatPattern)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatPattern);
            return cellFormatter.format(poiCell, locale);
        }
        CellFormatter cellFormatter = this.formatterResolver.createFormatter(formatPattern);
        if (this.isCache()) {
            this.formatterResolver.registerFormatter(formatPattern, cellFormatter);
        }
        return cellFormatter.format(poiCell, locale);
    }

    public FormatterResolver getFormatterResolver() {
        return this.formatterResolver;
    }

    public void setFormatterResolver(FormatterResolver formatterResolver) {
        this.formatterResolver = formatterResolver;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isErrorCellAsEmpty() {
        return this.errorCellAsEmpty;
    }

    public void setErrorCellAsEmpty(boolean errorCellAsEmpty) {
        this.errorCellAsEmpty = errorCellAsEmpty;
    }

    public boolean isThrowFailEvaluateFormula() {
        return this.throwFailEvaluateFormula;
    }

    public void setThrowFailEvaluateFormula(boolean throwFailEvaluateFormula) {
        this.throwFailEvaluateFormula = throwFailEvaluateFormula;
    }

    public boolean isConsiderMergedCell() {
        return this.considerMergedCell;
    }

    public void setConsiderMergedCell(boolean considerMergedCell) {
        this.considerMergedCell = considerMergedCell;
    }
}

