/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.CustomFormatter;
import com.github.mygreen.cellformatter.CustomFormatterFactory;
import com.github.mygreen.cellformatter.LocaleSwitchFormatter;
import com.github.mygreen.cellformatter.lang.MessageResolver;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FormatterResolver {
    private static final MessageResolver messageResolver = new MessageResolver("com.github.mygreen.cellformatter.format");
    private CustomFormatterFactory customFormatterFactory = new CustomFormatterFactory();
    private Map<Short, CellFormatter> indexFormatterMap = new ConcurrentHashMap<Short, CellFormatter>();
    private static final Locale LOCALE_JAPANESE = new Locale("ja", "JP", "JP");
    private static final Locale[] JAPANESE_LOCALES = new Locale[]{Locale.JAPANESE, Locale.JAPAN, LOCALE_JAPANESE};
    private Map<String, CellFormatter> patternFormatterMap = new ConcurrentHashMap<String, CellFormatter>();

    public FormatterResolver() {
        this.clearFormat();
        this.registerDefaultFormat();
    }

    public synchronized void clearFormat() {
        this.indexFormatterMap.clear();
        this.patternFormatterMap.clear();
    }

    public synchronized void registerDefaultFormat() {
        String[] names;
        Locale[] availableLocales = new Locale[]{Locale.JAPANESE};
        for (int i = 0; i <= 58; ++i) {
            CellFormatter formatter = this.createDefaultFormatter(String.valueOf(i), availableLocales);
            if (formatter == null) continue;
            this.registerFormatter((short)i, formatter);
        }
        for (String name : names = new String[]{"F800", "F400"}) {
            CellFormatter formatter;
            String key = String.format("format.%s", name);
            String defaultFormat = messageResolver.getMessage(key);
            if (defaultFormat == null || (formatter = this.createDefaultFormatter(name, availableLocales)) == null) continue;
            this.registerFormatter(defaultFormat, formatter);
        }
    }

    protected CellFormatter createDefaultFormatter(String name, Locale ... locales) {
        String key = String.format("format.%s", name);
        String defaultFormat = messageResolver.getMessage(key);
        if (defaultFormat == null) {
            return null;
        }
        CellFormatter formatter = this.createFormatter(defaultFormat);
        for (Locale locale : locales) {
            LocaleSwitchFormatter switchFormatter;
            String localeFormat = messageResolver.getMessage(locale, key, null);
            if (localeFormat == null) continue;
            if (formatter instanceof LocaleSwitchFormatter) {
                switchFormatter = (LocaleSwitchFormatter)formatter;
            } else {
                switchFormatter = new LocaleSwitchFormatter(formatter);
                formatter = switchFormatter;
            }
            if (locale.equals(Locale.JAPANESE)) {
                switchFormatter.register(this.createFormatter(localeFormat), JAPANESE_LOCALES);
                continue;
            }
            switchFormatter.register(this.createFormatter(localeFormat), locale);
        }
        return formatter;
    }

    public boolean canResolve(short formatIndex) {
        return this.indexFormatterMap.containsKey(formatIndex);
    }

    public boolean canResolve(String formatPattern) {
        String key = formatPattern == null ? "" : formatPattern;
        return this.patternFormatterMap.containsKey(key);
    }

    public CellFormatter getFormatter(short formatIndex) {
        return this.indexFormatterMap.get(formatIndex);
    }

    public CellFormatter getFormatter(String formatPattern) {
        String key = formatPattern == null ? "" : formatPattern;
        return this.patternFormatterMap.get(key);
    }

    public CellFormatter createFormatter(String formatPattern) {
        CustomFormatter formatter = this.customFormatterFactory.create(formatPattern);
        return formatter;
    }

    public synchronized CellFormatter registerFormatter(short formatIndex, CellFormatter cellFormatter) {
        return this.indexFormatterMap.put(formatIndex, cellFormatter);
    }

    public synchronized CellFormatter registerFormatter(String formatPattern, CellFormatter cellFormatter) {
        return this.patternFormatterMap.put(formatPattern, cellFormatter);
    }

    public CustomFormatterFactory getCustomFormatterFactory() {
        return this.customFormatterFactory;
    }

    public void setCustomFormatterFactory(CustomFormatterFactory customFormatterFactory) {
        this.customFormatterFactory = customFormatterFactory;
    }
}

