/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ConditionFormatterFactory;
import com.github.mygreen.cellformatter.ConditionTextFormatter;
import com.github.mygreen.cellformatter.LocaleSymbol;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.term.AsteriskTerm;
import com.github.mygreen.cellformatter.term.EscapedCharTerm;
import com.github.mygreen.cellformatter.term.LocaelSymbolTerm;
import com.github.mygreen.cellformatter.term.OtherTerm;
import com.github.mygreen.cellformatter.term.TextTerm;
import com.github.mygreen.cellformatter.term.UnderscoreTerm;
import com.github.mygreen.cellformatter.term.WordTerm;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.ArrayList;
import java.util.List;

public class ConditionTextFormatterFactory
extends ConditionFormatterFactory<ConditionTextFormatter> {
    public boolean isTextPattern(TokenStore store) {
        return store.containsInFactor("@");
    }

    @Override
    public ConditionTextFormatter create(TokenStore store) {
        ArgUtils.notNull(store, "store");
        ConditionTextFormatter formatter = new ConditionTextFormatter(store.getConcatenatedToken());
        for (Token token : store.getTokens()) {
            if (token instanceof Token.Condition) {
                Token.Condition conditionToken = token.asCondition();
                String condition = conditionToken.getCondition();
                formatter.addCondition(condition);
                if (this.isConditionOperator(conditionToken)) {
                    this.setupConditionOperator(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocale(conditionToken)) {
                    this.setupConditionLocale(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocaleSymbol(conditionToken)) {
                    LocaleSymbol localeSymbol = this.setupConditionLocaleSymbol(formatter, conditionToken);
                    formatter.addTerm(new LocaelSymbolTerm<String>(localeSymbol));
                    continue;
                }
                if (this.isConditionDbNum(conditionToken)) {
                    this.setupConditionDbNum(formatter, conditionToken);
                    continue;
                }
                if (!this.isConditionColor(conditionToken)) continue;
                this.setupConditionColor(formatter, conditionToken);
                continue;
            }
            if (token instanceof Token.Word) {
                formatter.addTerm(new WordTerm<String>(token.asWord()));
                continue;
            }
            if (token instanceof Token.EscapedChar) {
                formatter.addTerm(new EscapedCharTerm<String>(token.asEscapedChar()));
                continue;
            }
            if (token instanceof Token.Underscore) {
                formatter.addTerm(new UnderscoreTerm<String>(token.asUnderscore()));
                continue;
            }
            if (token instanceof Token.Asterisk) {
                formatter.addTerm(new AsteriskTerm<String>(token.asAsterisk()));
                continue;
            }
            if (!(token instanceof Token.Factor)) continue;
            List<Token> list = this.convertFactor(token.asFactor());
            for (Token item : list) {
                if (item.equals(Token.Symbol.SYMBOL_AT_MARK)) {
                    formatter.addTerm(TextTerm.atMark(item.asSymbol()));
                    continue;
                }
                formatter.addTerm(new OtherTerm<String>(item));
            }
        }
        return formatter;
    }

    private List<Token> convertFactor(Token.Factor factor) {
        String item = factor.getValue();
        int itemLength = item.length();
        ArrayList<Token> list = new ArrayList<Token>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < itemLength; ++i) {
            char c = item.charAt(i);
            if (c == '@') {
                list.add(Token.factor(sb.toString()));
                sb = new StringBuilder();
                list.add(Token.SYMBOL_AT_MARK);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            list.add(Token.factor(sb.toString()));
            sb = null;
        }
        return list;
    }
}

