/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.lang.MSColor;
import java.util.Date;
import java.util.TimeZone;

public class CellFormatResult {
    private Object value;
    private String text;
    private MSColor textColor;
    private String sectionPattern;
    private FormatCellType cellType;

    public Object getValue() {
        return this.value;
    }

    public double getValueAsDoulbe() {
        return (Double)this.value;
    }

    public Date getValueAsDate() {
        return this.getValueAsDate(null);
    }

    public Date getValueAsDate(TimeZone tz) {
        long time = ((Date)this.value).getTime();
        long offset = tz == null ? (long)TimeZone.getDefault().getRawOffset() : (long)tz.getRawOffset();
        return new Date(time - offset);
    }

    public String getValueAsString() {
        return (String)this.value;
    }

    public boolean getValueAsBoolean() {
        return (Boolean)this.value;
    }

    public boolean isBlank() {
        return this.getCellType() == FormatCellType.Blank;
    }

    public boolean isBoolean() {
        return this.getCellType() == FormatCellType.Boolean;
    }

    public boolean isDate() {
        return this.getCellType() == FormatCellType.Date;
    }

    public boolean isNumber() {
        return this.getCellType() == FormatCellType.Number;
    }

    public boolean isText() {
        return this.getCellType() == FormatCellType.Text;
    }

    public boolean isError() {
        return this.getCellType() == FormatCellType.Error;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public MSColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(MSColor textColor) {
        this.textColor = textColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSectionPattern() {
        return this.sectionPattern;
    }

    public void setSectionPattern(String sectionPattern) {
        this.sectionPattern = sectionPattern;
    }

    public FormatCellType getCellType() {
        return this.cellType;
    }

    public void setCellType(FormatCellType cellType) {
        this.cellType = cellType;
    }
}

