/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view;

import java.util.Map;
import java.util.TreeMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.LayoutRunner;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.view.GraphRenderer;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.ViewerPipe;
import org.graphstream.ui.view.camera.Camera;

public abstract class Viewer {
    protected boolean graphInAnotherThread = true;
    protected GraphicGraph graph;
    protected ProxyPipe pumpPipe;
    protected Source sourceInSameThread;
    protected final Map<String, View> views = new TreeMap<String, View>();
    protected CloseFramePolicy closeFramePolicy = CloseFramePolicy.EXIT;
    protected LayoutRunner optLayout = null;
    protected ProxyPipe layoutPipeIn = null;

    public abstract String getDefaultID();

    public String newGGId() {
        return String.format("GraphicGraph_%d", (int)(Math.random() * 10000.0));
    }

    public abstract void init(GraphicGraph var1, ProxyPipe var2, Source var3);

    public abstract void close();

    public CloseFramePolicy getCloseFramePolicy() {
        return this.closeFramePolicy;
    }

    public ProxyPipe newThreadProxyOnGraphicGraph() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph);
        return tpp;
    }

    public ViewerPipe newViewerPipe() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph, false);
        this.enableXYZfeedback(true);
        return new ViewerPipe(String.format("viewer_%d", (int)(Math.random() * 10000.0)), tpp);
    }

    public GraphicGraph getGraphicGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(String id) {
        Map<String, View> map = this.views;
        synchronized (map) {
            return this.views.get(id);
        }
    }

    public View getDefaultView() {
        return this.getView(this.getDefaultID());
    }

    public abstract GraphRenderer<?, ?> newDefaultGraphRenderer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addDefaultView(boolean openInAFrame) {
        Map<String, View> map = this.views;
        synchronized (map) {
            GraphRenderer<?, ?> renderer = this.newDefaultGraphRenderer();
            View view = renderer.createDefaultView(this, this.getDefaultID());
            this.addView(view);
            if (openInAFrame) {
                view.openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addView(View view) {
        Map<String, View> map = this.views;
        synchronized (map) {
            View old = this.views.put(view.getIdView(), view);
            if (old != null && old != view) {
                old.close(this.graph);
            }
            return old;
        }
    }

    public View addView(String id, GraphRenderer<?, ?> renderer) {
        return this.addView(id, renderer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addView(String id, GraphRenderer<?, ?> renderer, boolean openInAFrame) {
        Map<String, View> map = this.views;
        synchronized (map) {
            View view = renderer.createDefaultView(this, id);
            this.addView(view);
            if (openInAFrame) {
                view.openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String id) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.views.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeGraphMetrics() {
        this.graph.computeBounds();
        Map<String, View> map = this.views;
        synchronized (map) {
            Point3 lo = this.graph.getMinPos();
            Point3 hi = this.graph.getMaxPos();
            for (View view : this.views.values()) {
                Camera camera = view.getCamera();
                if (camera == null) continue;
                camera.setBounds(lo.x, lo.y, lo.z, hi.x, hi.y, hi.z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseFramePolicy(CloseFramePolicy policy) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.closeFramePolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableXYZfeedback(boolean on) {
        Map<String, View> map = this.views;
        synchronized (map) {
            this.graph.feedbackXYZ(on);
        }
    }

    public void enableAutoLayout() {
        this.enableAutoLayout(Layouts.newLayoutAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutoLayout(Layout layoutAlgorithm) {
        Map<String, View> map = this.views;
        synchronized (map) {
            if (this.optLayout == null) {
                this.optLayout = new LayoutRunner(this.graph, layoutAlgorithm, true, false);
                this.graph.replay();
                this.layoutPipeIn = this.optLayout.newLayoutPipe();
                this.layoutPipeIn.addAttributeSink(this.graph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAutoLayout() {
        Map<String, View> map = this.views;
        synchronized (map) {
            if (this.optLayout != null) {
                ((ThreadProxyPipe)this.layoutPipeIn).unregisterFromSource();
                this.layoutPipeIn.removeSink(this.graph);
                this.layoutPipeIn = null;
                this.optLayout.release();
                this.optLayout = null;
            }
        }
    }

    public void replayGraph(Graph graph) {
        graph.attributeKeys().forEach(key -> graph.setAttribute((String)key, graph.getAttribute((String)key)));
        graph.nodes().forEach(node -> {
            Node n = this.graph.addNode(node.getId());
            node.attributeKeys().forEach(key -> n.setAttribute((String)key, node.getAttribute((String)key)));
        });
        graph.edges().forEach(edge -> {
            Edge e = graph.addEdge(edge.getId(), edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected());
            edge.attributeKeys().forEach(key -> e.setAttribute((String)key, edge.getAttribute((String)key)));
        });
    }

    public static enum CloseFramePolicy {
        CLOSE_VIEWER,
        HIDE_ONLY,
        EXIT;

    }

    public static enum ThreadingModel {
        GRAPH_IN_GUI_THREAD,
        GRAPH_IN_ANOTHER_THREAD,
        GRAPH_ON_NETWORK;

    }
}

