/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.graphstream.graph.Graph;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.file.images.CustomResolution;
import org.graphstream.stream.file.images.FileSinkImagesFactory;
import org.graphstream.stream.file.images.Filter;
import org.graphstream.stream.file.images.Resolution;
import org.graphstream.stream.file.images.Resolutions;
import org.graphstream.stream.file.images.filters.AddLogoFilter;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.LayoutRunner;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.view.camera.Camera;
import org.graphstream.util.Display;
import org.graphstream.util.MissingDisplayException;

public abstract class FileSinkImages
implements FileSink {
    private static final Logger LOGGER = Logger.getLogger(FileSinkImages.class.getName());
    protected Resolution resolution;
    protected OutputType outputType;
    protected String filePrefix;
    protected final GraphicGraph gg;
    protected Sink sink;
    protected int counter;
    protected OutputPolicy outputPolicy;
    protected LinkedList<Filter> filters;
    protected LayoutPolicy layoutPolicy;
    protected LayoutRunner optLayout;
    protected ProxyPipe layoutPipeIn;
    protected Layout layout;
    protected float layoutStabilizationLimit = 0.9f;
    protected int layoutStepAfterStabilization = 10;
    protected int layoutStepPerFrame = 4;
    protected int layoutStepWithoutFrame = 0;
    protected long outputRunnerDelay = 10L;
    protected boolean outputRunnerAlive = false;
    protected OutputRunner outputRunner;
    protected ThreadProxyPipe outputRunnerProxy;
    protected boolean clearImageBeforeOutput = false;
    protected boolean hasBegun = false;
    protected boolean autofit = true;
    protected String styleSheet = null;

    public static FileSinkImages createDefault() {
        try {
            Display display = Display.getDefault();
            if (display instanceof FileSinkImagesFactory) {
                return ((FileSinkImagesFactory)((Object)display)).createFileSinkImages();
            }
            LOGGER.warning("Default UI module does not provide a FileSinkImages implementation");
        }
        catch (MissingDisplayException e) {
            LOGGER.warning("No valid UI module specified in \"org.graphstream.ui\" system property");
        }
        return null;
    }

    protected FileSinkImages() {
        this(OutputType.PNG, Resolutions.HD720);
    }

    protected FileSinkImages(OutputType type, Resolution resolution) {
        this(type, resolution, OutputPolicy.NONE);
    }

    protected FileSinkImages(OutputType type, Resolution resolution, OutputPolicy outputPolicy) {
        this.resolution = resolution;
        this.outputType = type;
        this.filePrefix = "frame_";
        this.counter = 0;
        this.gg = new GraphicGraph(String.format("images-%x", System.currentTimeMillis()));
        this.filters = new LinkedList();
        this.layoutPolicy = LayoutPolicy.NO_LAYOUT;
        this.layout = null;
        this.optLayout = null;
        this.layoutPipeIn = null;
        this.sink = this.gg;
        this.setOutputPolicy(outputPolicy);
    }

    protected abstract Camera getCamera();

    protected abstract void render();

    protected abstract BufferedImage getRenderedImage();

    protected abstract void initImage();

    protected abstract void clearImage(int var1);

    public void setQuality(Quality q) {
        switch (q) {
            case LOW: {
                if (this.gg.hasAttribute("ui.quality")) {
                    this.gg.removeAttribute("ui.quality");
                }
                if (!this.gg.hasAttribute("ui.antialias")) break;
                this.gg.removeAttribute("ui.antialias");
                break;
            }
            case MEDIUM: {
                if (!this.gg.hasAttribute("ui.quality")) {
                    this.gg.setAttribute("ui.quality", new Object[0]);
                }
                if (!this.gg.hasAttribute("ui.antialias")) break;
                this.gg.removeAttribute("ui.antialias");
                break;
            }
            case HIGH: {
                if (!this.gg.hasAttribute("ui.quality")) {
                    this.gg.setAttribute("ui.quality", new Object[0]);
                }
                if (this.gg.hasAttribute("ui.antialias")) break;
                this.gg.setAttribute("ui.antialias", new Object[0]);
            }
        }
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
        this.gg.setAttribute("ui.stylesheet", styleSheet);
    }

    public void setResolution(Resolution r) {
        if (r != this.resolution) {
            this.resolution = r;
            this.initImage();
        }
    }

    public void setResolution(int width, int height) {
        if (this.resolution == null || this.resolution.getWidth() != width || this.resolution.getHeight() != height) {
            this.setResolution(new CustomResolution(width, height));
        }
    }

    public void setOutputPolicy(OutputPolicy policy) {
        this.outputPolicy = policy;
    }

    public void setOutputType(OutputType outputType) {
        if (outputType != this.outputType) {
            this.outputType = outputType;
            this.initImage();
        }
    }

    public synchronized void setLayoutPolicy(LayoutPolicy policy) {
        if (policy != this.layoutPolicy) {
            switch (this.layoutPolicy) {
                case COMPUTED_IN_LAYOUT_RUNNER: {
                    this.optLayout.release();
                    this.optLayout = null;
                    this.layoutPipeIn.removeAttributeSink(this.gg);
                    this.layoutPipeIn = null;
                    this.layout = null;
                    break;
                }
                case COMPUTED_ONCE_AT_NEW_IMAGE: {
                    this.gg.removeSink(this.layout);
                    this.layout.removeAttributeSink(this.gg);
                    this.layout = null;
                    break;
                }
            }
            switch (policy) {
                case COMPUTED_IN_LAYOUT_RUNNER: {
                    this.layout = Layouts.newLayoutAlgorithm();
                    this.optLayout = new InnerLayoutRunner();
                    break;
                }
                case COMPUTED_ONCE_AT_NEW_IMAGE: 
                case COMPUTED_FULLY_AT_NEW_IMAGE: {
                    this.layout = Layouts.newLayoutAlgorithm();
                    this.gg.addSink(this.layout);
                    this.layout.addAttributeSink(this.gg);
                    break;
                }
            }
            this.layoutPolicy = policy;
        }
    }

    public void setLayoutStepPerFrame(int spf) {
        this.layoutStepPerFrame = spf;
    }

    public void setLayoutStepAfterStabilization(int sas) {
        this.layoutStepAfterStabilization = sas;
    }

    public void setLayoutStabilizationLimit(double limit) {
        if (this.layout == null) {
            throw new NullPointerException("did you enable layout ?");
        }
        this.layout.setStabilizationLimit(limit);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public synchronized void setOutputRunnerEnabled(boolean on) {
        if (!on && this.outputRunnerAlive) {
            this.outputRunnerAlive = false;
            try {
                if (this.outputRunner != null) {
                    this.outputRunner.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.outputRunner = null;
            this.sink = this.gg;
            if (this.outputRunnerProxy != null) {
                this.outputRunnerProxy.pump();
            }
        }
        this.outputRunnerAlive = on;
        if (this.outputRunnerAlive) {
            if (this.outputRunnerProxy == null) {
                this.outputRunnerProxy = new ThreadProxyPipe();
                this.outputRunnerProxy.init(this.gg);
            }
            this.sink = this.outputRunnerProxy;
            this.outputRunner = new OutputRunner();
            this.outputRunner.start();
        }
    }

    public void setOutputRunnerDelay(long delay) {
        this.outputRunnerDelay = delay;
    }

    public void stabilizeLayout(double limit) {
        if (this.layout != null) {
            while (this.layout.getStabilization() < limit) {
                this.layout.compute();
            }
        }
    }

    public Point3 getViewCenter() {
        return this.getCamera().getViewCenter();
    }

    public void setViewCenter(double x, double y) {
        this.getCamera().setViewCenter(x, y, 0.0);
    }

    public double getViewPercent() {
        return this.getCamera().getViewPercent();
    }

    public void setViewPercent(double zoom) {
        this.getCamera().setViewPercent(zoom);
    }

    public void setGraphViewport(double minx, double miny, double maxx, double maxy) {
        this.getCamera().setGraphViewport(minx, miny, maxx, maxy);
    }

    public void setClearImageBeforeOutputEnabled(boolean on) {
        this.clearImageBeforeOutput = on;
    }

    public void setAutofit(boolean on) {
        this.autofit = on;
    }

    protected void clearGG() {
        this.gg.clear();
        if (this.styleSheet != null) {
            this.gg.setAttribute("ui.stylesheet", this.styleSheet);
        }
        if (this.layout != null) {
            this.layout.clear();
        }
    }

    public void outputNewImage() {
        this.outputNewImage(String.format("%s%06d.%s", this.filePrefix, this.counter++, this.outputType.ext));
    }

    public synchronized void outputNewImage(String filename) {
        switch (this.layoutPolicy) {
            case COMPUTED_IN_LAYOUT_RUNNER: {
                this.layoutPipeIn.pump();
                break;
            }
            case COMPUTED_ONCE_AT_NEW_IMAGE: {
                if (this.layout == null) break;
                this.layout.compute();
                break;
            }
            case COMPUTED_FULLY_AT_NEW_IMAGE: {
                this.stabilizeLayout(this.layout.getStabilizationLimit());
                break;
            }
        }
        if (this.clearImageBeforeOutput || this.gg.getNodeCount() == 0) {
            this.clearImage(0);
        }
        if (this.gg.getNodeCount() > 0) {
            if (this.autofit) {
                this.gg.computeBounds();
                Point3 lo = this.gg.getMinPos();
                Point3 hi = this.gg.getMaxPos();
                this.getCamera().setBounds(lo.x, lo.y, lo.z, hi.x, hi.y, hi.z);
            }
            this.render();
        }
        BufferedImage image = this.getRenderedImage();
        for (Filter action : this.filters) {
            action.apply(image);
        }
        image.flush();
        try {
            this.writeImage(image, filename);
            this.printProgress();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to write image", e);
        }
    }

    protected void writeImage(BufferedImage image, String filename) throws IOException {
        File out = new File(filename);
        if (out.getParent() != null && !out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        ImageIO.write((RenderedImage)image, this.outputType.name(), out);
    }

    protected void printProgress() {
        LOGGER.info(String.format("\u001b[s\u001b[K%d images written\u001b[u", this.counter));
    }

    @Override
    public void begin(OutputStream stream) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void begin(Writer writer) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void begin(String prefix) throws IOException {
        this.initImage();
        this.filePrefix = prefix;
        this.hasBegun = true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void end() throws IOException {
        this.flush();
        this.hasBegun = false;
    }

    @Override
    public void writeAll(Graph g, OutputStream stream) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public void writeAll(Graph g, Writer writer) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public synchronized void writeAll(Graph g, String filename) throws IOException {
        this.clearGG();
        GraphReplay replay = new GraphReplay(String.format("file_sink_image-write_all-replay-%x", System.nanoTime()));
        replay.addSink(this.gg);
        replay.replay(g);
        replay.removeSink(this.gg);
        this.initImage();
        this.outputNewImage(filename);
        this.clearGG();
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.sink.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: 
            case BY_ATTRIBUTE_EVENT: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sink.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: 
            case BY_ATTRIBUTE_EVENT: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.sink.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ATTRIBUTE: 
            case BY_ATTRIBUTE_EVENT: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.sink.graphAttributeAdded(sourceId, timeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.sink.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.sink.graphAttributeRemoved(sourceId, timeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_GRAPH_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.sink.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sink.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.sink.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_ATTRIBUTE_EVENT: 
            case BY_NODE_EVENT: 
            case BY_NODE_ATTRIBUTE: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.sink.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ADDED_REMOVED: 
            case BY_ELEMENT_EVENT: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.sink.edgeRemoved(sourceId, timeId, edgeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_EDGE_EVENT: 
            case BY_EDGE_ADDED_REMOVED: 
            case BY_ELEMENT_EVENT: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.sink.graphCleared(sourceId, timeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_GRAPH_EVENT: 
            case BY_EDGE_ADDED_REMOVED: 
            case BY_ELEMENT_EVENT: 
            case BY_NODE_ADDED_REMOVED: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.sink.nodeAdded(sourceId, timeId, nodeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_NODE_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_NODE_ADDED_REMOVED: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.sink.nodeRemoved(sourceId, timeId, nodeId);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_NODE_EVENT: 
            case BY_ELEMENT_EVENT: 
            case BY_NODE_ADDED_REMOVED: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.sink.stepBegins(sourceId, timeId, step);
        switch (this.outputPolicy) {
            case BY_EVENT: 
            case BY_STEP: {
                if (!this.hasBegun) break;
                this.outputNewImage();
                break;
            }
        }
    }

    public static void usage() {
        LOGGER.info(String.format("usage: java %s [options] fichier.dgs%n", FileSinkImages.class.getName()));
        LOGGER.info(String.format("where options in:%n", new Object[0]));
        for (Option option : Option.values()) {
            LOGGER.info(String.format("%n --%s%s , -%s %s%n%s%n", option.fullopts, option.valuable ? "=..." : "", Character.valueOf(option.shortopts), option.valuable ? "..." : "", option.description));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String ... args) throws IOException {
        void var6_14;
        Object test;
        HashMap<Option, String> options = new HashMap<Option, String>();
        LinkedList<String> others = new LinkedList<String>();
        for (Option option : Option.values()) {
            if (option.defaultValue == null) continue;
            options.put(option, option.defaultValue);
        }
        if (args != null && args.length > 0) {
            Pattern valueGetter = Pattern.compile("^--\\w[\\w-]*\\w?(?:=(?:\"([^\"]*)\"|([^\\s]*)))$");
            for (int i = 0; i < args.length; ++i) {
                boolean found;
                if (args[i].matches("^--\\w[\\w-]*\\w?(=(\"[^\"]*\"|[^\\s]*))?$")) {
                    found = false;
                    for (Option option : Option.values()) {
                        if (!args[i].startsWith("--" + option.fullopts + "=")) continue;
                        Matcher m = valueGetter.matcher(args[i]);
                        if (m.matches()) {
                            options.put(option, m.group(1) == null ? m.group(2) : m.group(1));
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LOGGER.severe(String.format("unknown option: %s%n", args[i].substring(0, args[i].indexOf(61))));
                    System.exit(1);
                    continue;
                }
                if (args[i].matches("^-\\w$")) {
                    found = false;
                    for (Option option : Option.values()) {
                        if (!args[i].equals("-" + option.shortopts)) continue;
                        options.put(option, args[++i]);
                        break;
                    }
                    if (found) continue;
                    LOGGER.severe(String.format("unknown option: %s%n", args[i]));
                    System.exit(1);
                    continue;
                }
                others.addLast(args[i]);
            }
        } else {
            FileSinkImages.usage();
            System.exit(0);
        }
        LinkedList<String> errors = new LinkedList<String>();
        if (others.size() == 0) {
            errors.add("dgs file name missing.");
        }
        OutputType outputType = null;
        Object var6_12 = null;
        Resolution resolution = null;
        Quality quality = null;
        String imagePrefix = (String)options.get((Object)Option.IMAGE_PREFIX);
        try {
            outputType = OutputType.valueOf((String)options.get((Object)Option.IMAGE_TYPE));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad image type: " + (String)options.get((Object)Option.IMAGE_TYPE));
        }
        try {
            OutputPolicy outputPolicy = OutputPolicy.valueOf((String)options.get((Object)Option.OUTPUT_POLICY));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad output policy: " + (String)options.get((Object)Option.OUTPUT_POLICY));
        }
        try {
            quality = Quality.valueOf((String)options.get((Object)Option.QUALITY));
        }
        catch (IllegalArgumentException e) {
            errors.add("bad quality: " + (String)options.get((Object)Option.QUALITY));
        }
        String logo = (String)options.get((Object)Option.LOGO);
        String stylesheet = (String)options.get((Object)Option.STYLESHEET);
        try {
            resolution = Resolutions.valueOf((String)options.get((Object)Option.IMAGE_RESOLUTION));
        }
        catch (IllegalArgumentException e) {
            Pattern p = Pattern.compile("^\\s*(\\d+)\\s*x\\s*(\\d+)\\s*$");
            Matcher m = p.matcher((CharSequence)options.get((Object)Option.IMAGE_RESOLUTION));
            if (m.matches()) {
                resolution = new CustomResolution(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            }
            errors.add("bad resolution: " + (String)options.get((Object)Option.IMAGE_RESOLUTION));
        }
        if (stylesheet != null && stylesheet.length() < 1024 && ((File)(test = new File(stylesheet))).exists()) {
            FileReader in = new FileReader((File)test);
            char[] buffer = new char[128];
            String content = "";
            while (in.ready()) {
                int c = in.read(buffer, 0, 128);
                content = content + new String(buffer, 0, c);
            }
            stylesheet = content;
            in.close();
        }
        if (!((File)(test = new File((String)others.peek()))).exists()) {
            errors.add(String.format("file \"%s\" does not exist", others.peek()));
        }
        if (errors.size() > 0) {
            LOGGER.info(String.format("error:%n", new Object[0]));
            for (String error : errors) {
                LOGGER.info(String.format("- %s%n", error));
            }
            System.exit(1);
        }
        FileSourceDGS dgs = new FileSourceDGS();
        FileSinkImages fsi = FileSinkImages.createDefault();
        fsi.setOutputPolicy((OutputPolicy)var6_14);
        fsi.setResolution(resolution);
        fsi.setOutputType(outputType);
        dgs.addSink(fsi);
        if (logo != null) {
            fsi.addFilter(new AddLogoFilter(logo, 0, 0));
        }
        fsi.setQuality(quality);
        if (stylesheet != null) {
            fsi.setStyleSheet(stylesheet);
        }
        boolean next = true;
        dgs.begin((String)others.get(0));
        while (next) {
            next = dgs.nextStep();
        }
        dgs.end();
    }

    protected class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (FileSinkImages.this.outputRunnerAlive && FileSinkImages.this.outputPolicy == OutputPolicy.ON_RUNNER) {
                FileSinkImages.this.outputRunnerProxy.pump();
                if (FileSinkImages.this.hasBegun) {
                    FileSinkImages.this.outputNewImage();
                }
                try {
                    Thread.sleep(FileSinkImages.this.outputRunnerDelay);
                }
                catch (InterruptedException e) {
                    FileSinkImages.this.outputRunnerAlive = false;
                }
            }
        }
    }

    protected class InnerLayoutRunner
    extends LayoutRunner {
        public InnerLayoutRunner() {
            super(FileSinkImages.this.gg, FileSinkImages.this.layout, true, true);
            FileSinkImages.this.layoutPipeIn = this.newLayoutPipe();
            FileSinkImages.this.layoutPipeIn.addAttributeSink(FileSinkImages.this.gg);
        }

        @Override
        public void run() {
            int stepAfterStabilization = 0;
            do {
                this.pumpPipe.pump();
                this.layout.compute();
                stepAfterStabilization = this.layout.getStabilization() > this.layout.getStabilizationLimit() ? ++stepAfterStabilization : 0;
                this.nap(80L);
                if (stepAfterStabilization <= FileSinkImages.this.layoutStepAfterStabilization) continue;
                this.loop = false;
            } while (this.loop);
        }
    }

    public static enum Option {
        IMAGE_PREFIX("image-prefix", 'p', "prefix of outputted images", true, true, "image_"),
        IMAGE_TYPE("image-type", 't', "image type. one of " + Arrays.toString((Object[])OutputType.values()), true, true, "PNG"),
        IMAGE_RESOLUTION("image-resolution", 'r', "defines images resolution. \"width x height\" or one of " + Arrays.toString(Resolutions.values()), true, true, "HD720"),
        OUTPUT_POLICY("output-policy", 'e', "defines when images are outputted. one of " + Arrays.toString((Object[])OutputPolicy.values()), true, true, "ByStepOutput"),
        LOGO("logo", 'l', "add a logo to images", true, true, null),
        STYLESHEET("stylesheet", 's', "defines stylesheet of graph. can be a file or a string.", true, true, null),
        QUALITY("quality", 'q', "defines quality of rendering. one of " + Arrays.toString((Object[])Quality.values()), true, true, "HIGH");

        String fullopts;
        char shortopts;
        String description;
        boolean optional;
        boolean valuable;
        String defaultValue;

        private Option(String fullopts, char shortopts, String description, boolean optional, boolean valuable, String defaultValue) {
            this.fullopts = fullopts;
            this.shortopts = shortopts;
            this.description = description;
            this.optional = optional;
            this.valuable = valuable;
            this.defaultValue = defaultValue;
        }
    }

    public static enum Quality {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum LayoutPolicy {
        NO_LAYOUT,
        COMPUTED_IN_LAYOUT_RUNNER,
        COMPUTED_ONCE_AT_NEW_IMAGE,
        COMPUTED_FULLY_AT_NEW_IMAGE;

    }

    public static enum OutputPolicy {
        BY_EVENT,
        BY_ELEMENT_EVENT,
        BY_ATTRIBUTE_EVENT,
        BY_NODE_EVENT,
        BY_EDGE_EVENT,
        BY_GRAPH_EVENT,
        BY_STEP,
        BY_NODE_ADDED_REMOVED,
        BY_EDGE_ADDED_REMOVED,
        BY_NODE_ATTRIBUTE,
        BY_EDGE_ATTRIBUTE,
        BY_GRAPH_ATTRIBUTE,
        BY_LAYOUT_STEP,
        BY_NODE_MOVED,
        ON_RUNNER,
        NONE;

    }

    public static enum OutputType {
        PNG(2, "png"),
        JPG(1, "jpg"),
        png(2, "png"),
        jpg(1, "jpg");

        public final int imageType;
        public final String ext;

        private OutputType(int imageType, String ext) {
            this.imageType = imageType;
            this.ext = ext;
        }
    }
}

