/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.sync.SourceTime;

public abstract class SourceBase
implements Source {
    protected ArrayList<AttributeSink> attrSinks = new ArrayList();
    protected ArrayList<ElementSink> eltsSinks = new ArrayList();
    protected Queue<GraphEvent> eventQueue = new ConcurrentLinkedQueue<GraphEvent>();
    protected boolean eventProcessing = false;
    protected String sourceId;
    protected SourceTime sourceTime;

    protected SourceBase() {
        this(String.format("sourceOnThread#%d_%d", Thread.currentThread().getId(), System.currentTimeMillis() + (long)((int)(Math.random() * 1000.0))));
    }

    protected SourceBase(String sourceId) {
        this.sourceId = sourceId;
        this.sourceTime = new SourceTime(sourceId);
    }

    public Iterable<AttributeSink> attributeSinks() {
        return this.attrSinks;
    }

    public Iterable<ElementSink> elementSinks() {
        return this.eltsSinks;
    }

    @Override
    public void addSink(Sink sink) {
        this.addAttributeSink(sink);
        this.addElementSink(sink);
    }

    @Override
    public void addAttributeSink(AttributeSink sink) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.attrSinks.add(sink);
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new AddToListEvent<AttributeSink>(this.attrSinks, sink));
        }
    }

    @Override
    public void addElementSink(ElementSink sink) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.eltsSinks.add(sink);
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new AddToListEvent<ElementSink>(this.eltsSinks, sink));
        }
    }

    @Override
    public void clearSinks() {
        this.clearElementSinks();
        this.clearAttributeSinks();
    }

    @Override
    public void clearElementSinks() {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.eltsSinks.clear();
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new ClearListEvent<ElementSink>(this.eltsSinks));
        }
    }

    @Override
    public void clearAttributeSinks() {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.attrSinks.clear();
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new ClearListEvent<AttributeSink>(this.attrSinks));
        }
    }

    @Override
    public void removeSink(Sink sink) {
        this.removeAttributeSink(sink);
        this.removeElementSink(sink);
    }

    @Override
    public void removeAttributeSink(AttributeSink sink) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.attrSinks.remove(sink);
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new RemoveFromListEvent<AttributeSink>(this.attrSinks, sink));
        }
    }

    @Override
    public void removeElementSink(ElementSink sink) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            this.eltsSinks.remove(sink);
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new RemoveFromListEvent<ElementSink>(this.eltsSinks, sink));
        }
    }

    public void sendGraphCleared(String sourceId) {
        this.sendGraphCleared(sourceId, this.sourceTime.newEvent());
    }

    public void sendGraphCleared(String sourceId, long timeId) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).graphCleared(sourceId, timeId);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new BeforeGraphClearEvent(sourceId, timeId));
        }
    }

    public void sendStepBegins(String sourceId, double step) {
        this.sendStepBegins(sourceId, this.sourceTime.newEvent(), step);
    }

    public void sendStepBegins(String sourceId, long timeId, double step) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).stepBegins(sourceId, timeId, step);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new StepBeginsEvent(sourceId, timeId, step));
        }
    }

    public void sendNodeAdded(String sourceId, String nodeId) {
        this.sendNodeAdded(sourceId, this.sourceTime.newEvent(), nodeId);
    }

    public void sendNodeAdded(String sourceId, long timeId, String nodeId) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).nodeAdded(sourceId, timeId, nodeId);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new AfterNodeAddEvent(sourceId, timeId, nodeId));
        }
    }

    public void sendNodeRemoved(String sourceId, String nodeId) {
        this.sendNodeRemoved(sourceId, this.sourceTime.newEvent(), nodeId);
    }

    public void sendNodeRemoved(String sourceId, long timeId, String nodeId) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).nodeRemoved(sourceId, timeId, nodeId);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new BeforeNodeRemoveEvent(sourceId, timeId, nodeId));
        }
    }

    public void sendEdgeAdded(String sourceId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.sendEdgeAdded(sourceId, this.sourceTime.newEvent(), edgeId, fromNodeId, toNodeId, directed);
    }

    public void sendEdgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new AfterEdgeAddEvent(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed));
        }
    }

    public void sendEdgeRemoved(String sourceId, String edgeId) {
        this.sendEdgeRemoved(sourceId, this.sourceTime.newEvent(), edgeId);
    }

    public void sendEdgeRemoved(String sourceId, long timeId, String edgeId) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            for (int i = 0; i < this.eltsSinks.size(); ++i) {
                this.eltsSinks.get(i).edgeRemoved(sourceId, timeId, edgeId);
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new BeforeEdgeRemoveEvent(sourceId, timeId, edgeId));
        }
    }

    public void sendEdgeAttributeAdded(String sourceId, String edgeId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendEdgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, timeId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendEdgeAttributeChanged(String sourceId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendEdgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, timeId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendEdgeAttributeRemoved(String sourceId, String edgeId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendEdgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, timeId, edgeId, ElementType.EDGE, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendGraphAttributeAdded(String sourceId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendGraphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, timeId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendGraphAttributeChanged(String sourceId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendGraphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, timeId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendGraphAttributeRemoved(String sourceId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendGraphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, timeId, null, ElementType.GRAPH, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendNodeAttributeAdded(String sourceId, String nodeId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendNodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.sendAttributeChangedEvent(sourceId, timeId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    public void sendNodeAttributeChanged(String sourceId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendNodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, timeId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.CHANGE, oldValue, newValue);
    }

    public void sendNodeAttributeRemoved(String sourceId, String nodeId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendNodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.sendAttributeChangedEvent(sourceId, timeId, nodeId, ElementType.NODE, attribute, AbstractElement.AttributeChangeEvent.REMOVE, null, null);
    }

    public void sendAttributeChangedEvent(String sourceId, String eltId, ElementType eltType, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        this.sendAttributeChangedEvent(sourceId, this.sourceTime.newEvent(), eltId, eltType, attribute, event, oldValue, newValue);
    }

    public void sendAttributeChangedEvent(String sourceId, long timeId, String eltId, ElementType eltType, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        if (!this.eventProcessing) {
            this.eventProcessing = true;
            this.manageEvents();
            if (event == AbstractElement.AttributeChangeEvent.ADD) {
                if (eltType == ElementType.NODE) {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).nodeAttributeAdded(sourceId, timeId, eltId, attribute, newValue);
                    }
                } else if (eltType == ElementType.EDGE) {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).edgeAttributeAdded(sourceId, timeId, eltId, attribute, newValue);
                    }
                } else {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).graphAttributeAdded(sourceId, timeId, attribute, newValue);
                    }
                }
            } else if (event == AbstractElement.AttributeChangeEvent.REMOVE) {
                if (eltType == ElementType.NODE) {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).nodeAttributeRemoved(sourceId, timeId, eltId, attribute);
                    }
                } else if (eltType == ElementType.EDGE) {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).edgeAttributeRemoved(sourceId, timeId, eltId, attribute);
                    }
                } else {
                    for (int i = 0; i < this.attrSinks.size(); ++i) {
                        this.attrSinks.get(i).graphAttributeRemoved(sourceId, timeId, attribute);
                    }
                }
            } else if (eltType == ElementType.NODE) {
                for (int i = 0; i < this.attrSinks.size(); ++i) {
                    this.attrSinks.get(i).nodeAttributeChanged(sourceId, timeId, eltId, attribute, oldValue, newValue);
                }
            } else if (eltType == ElementType.EDGE) {
                for (int i = 0; i < this.attrSinks.size(); ++i) {
                    this.attrSinks.get(i).edgeAttributeChanged(sourceId, timeId, eltId, attribute, oldValue, newValue);
                }
            } else {
                for (int i = 0; i < this.attrSinks.size(); ++i) {
                    this.attrSinks.get(i).graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
                }
            }
            this.manageEvents();
            this.eventProcessing = false;
        } else {
            this.eventQueue.add(new AttributeChangedEvent(sourceId, timeId, eltId, eltType, attribute, event, oldValue, newValue));
        }
    }

    protected void manageEvents() {
        if (this.eventProcessing) {
            while (!this.eventQueue.isEmpty()) {
                this.eventQueue.remove().trigger();
            }
        }
    }

    class ClearListEvent<T>
    extends GraphEvent {
        List<T> l;

        ClearListEvent(List<T> l) {
            super(null, -1L);
            this.l = l;
        }

        @Override
        void trigger() {
            this.l.clear();
        }
    }

    class RemoveFromListEvent<T>
    extends GraphEvent {
        List<T> l;
        T obj;

        RemoveFromListEvent(List<T> l, T obj) {
            super(null, -1L);
            this.l = l;
            this.obj = obj;
        }

        @Override
        void trigger() {
            this.l.remove(this.obj);
        }
    }

    class AddToListEvent<T>
    extends GraphEvent {
        List<T> l;
        T obj;

        AddToListEvent(List<T> l, T obj) {
            super(null, -1L);
            this.l = l;
            this.obj = obj;
        }

        @Override
        void trigger() {
            this.l.add(this.obj);
        }
    }

    class AttributeChangedEvent
    extends GraphEvent {
        ElementType eltType;
        String eltId;
        String attribute;
        AbstractElement.AttributeChangeEvent event;
        Object oldValue;
        Object newValue;

        AttributeChangedEvent(String sourceId, long timeId, String eltId, ElementType eltType, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
            super(sourceId, timeId);
            this.eltType = eltType;
            this.eltId = eltId;
            this.attribute = attribute;
            this.event = event;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        void trigger() {
            block0 : switch (this.event) {
                case ADD: {
                    switch (this.eltType) {
                        case NODE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).nodeAttributeAdded(this.sourceId, this.timeId, this.eltId, this.attribute, this.newValue);
                            }
                            break block0;
                        }
                        case EDGE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).edgeAttributeAdded(this.sourceId, this.timeId, this.eltId, this.attribute, this.newValue);
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).graphAttributeAdded(this.sourceId, this.timeId, this.attribute, this.newValue);
                            }
                            break block0;
                        }
                    }
                }
                case REMOVE: {
                    switch (this.eltType) {
                        case NODE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).nodeAttributeRemoved(this.sourceId, this.timeId, this.eltId, this.attribute);
                            }
                            break block0;
                        }
                        case EDGE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).edgeAttributeRemoved(this.sourceId, this.timeId, this.eltId, this.attribute);
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).graphAttributeRemoved(this.sourceId, this.timeId, this.attribute);
                            }
                            break block0;
                        }
                    }
                }
                default: {
                    switch (this.eltType) {
                        case NODE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).nodeAttributeChanged(this.sourceId, this.timeId, this.eltId, this.attribute, this.oldValue, this.newValue);
                            }
                            break block0;
                        }
                        case EDGE: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).edgeAttributeChanged(this.sourceId, this.timeId, this.eltId, this.attribute, this.oldValue, this.newValue);
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < SourceBase.this.attrSinks.size(); ++i) {
                                SourceBase.this.attrSinks.get(i).graphAttributeChanged(this.sourceId, this.timeId, this.attribute, this.oldValue, this.newValue);
                            }
                        }
                    }
                }
            }
        }
    }

    class StepBeginsEvent
    extends GraphEvent {
        double step;

        StepBeginsEvent(String sourceId, long timeId, double step) {
            super(sourceId, timeId);
            this.step = step;
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).stepBegins(this.sourceId, this.timeId, this.step);
            }
        }
    }

    class BeforeGraphClearEvent
    extends GraphEvent {
        BeforeGraphClearEvent(String sourceId, long timeId) {
            super(sourceId, timeId);
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).graphCleared(this.sourceId, this.timeId);
            }
        }
    }

    class BeforeNodeRemoveEvent
    extends GraphEvent {
        String nodeId;

        BeforeNodeRemoveEvent(String sourceId, long timeId, String nodeId) {
            super(sourceId, timeId);
            this.nodeId = nodeId;
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).nodeRemoved(this.sourceId, this.timeId, this.nodeId);
            }
        }
    }

    class AfterNodeAddEvent
    extends GraphEvent {
        String nodeId;

        AfterNodeAddEvent(String sourceId, long timeId, String nodeId) {
            super(sourceId, timeId);
            this.nodeId = nodeId;
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).nodeAdded(this.sourceId, this.timeId, this.nodeId);
            }
        }
    }

    class BeforeEdgeRemoveEvent
    extends GraphEvent {
        String edgeId;

        BeforeEdgeRemoveEvent(String sourceId, long timeId, String edgeId) {
            super(sourceId, timeId);
            this.edgeId = edgeId;
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).edgeRemoved(this.sourceId, this.timeId, this.edgeId);
            }
        }
    }

    class AfterEdgeAddEvent
    extends GraphEvent {
        String edgeId;
        String fromNodeId;
        String toNodeId;
        boolean directed;

        AfterEdgeAddEvent(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            super(sourceId, timeId);
            this.edgeId = edgeId;
            this.fromNodeId = fromNodeId;
            this.toNodeId = toNodeId;
            this.directed = directed;
        }

        @Override
        void trigger() {
            for (int i = 0; i < SourceBase.this.eltsSinks.size(); ++i) {
                SourceBase.this.eltsSinks.get(i).edgeAdded(this.sourceId, this.timeId, this.edgeId, this.fromNodeId, this.toNodeId, this.directed);
            }
        }
    }

    abstract class GraphEvent {
        String sourceId;
        long timeId;

        GraphEvent(String sourceId, long timeId) {
            this.sourceId = sourceId;
            this.timeId = timeId;
        }

        abstract void trigger();
    }

    public static enum ElementType {
        NODE,
        EDGE,
        GRAPH;

    }
}

