/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.EdgeRejectedException;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.Replayable;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.view.Viewer;
import org.graphstream.util.Display;
import org.graphstream.util.GraphListeners;
import org.graphstream.util.MissingDisplayException;

public abstract class AbstractGraph
extends AbstractElement
implements Graph,
Replayable {
    GraphListeners listeners;
    private boolean strictChecking;
    private boolean autoCreate;
    private NodeFactory<? extends AbstractNode> nodeFactory;
    private EdgeFactory<? extends AbstractEdge> edgeFactory;
    private double step = 0.0;
    private long replayId = 0L;

    public AbstractGraph(String id) {
        this(id, true, false);
    }

    public AbstractGraph(String id, boolean strictChecking, boolean autoCreate) {
        super(id);
        this.strictChecking = strictChecking;
        this.autoCreate = autoCreate;
        this.listeners = new GraphListeners(this);
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        this.listeners.sendAttributeChangedEvent(this.id, SourceBase.ElementType.GRAPH, attribute, event, oldValue, newValue);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes().iterator();
    }

    @Override
    public NodeFactory<? extends Node> nodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public EdgeFactory<? extends Edge> edgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public void setNodeFactory(NodeFactory<? extends Node> nf) {
        this.nodeFactory = nf;
    }

    @Override
    public void setEdgeFactory(EdgeFactory<? extends Edge> ef) {
        this.edgeFactory = ef;
    }

    @Override
    public boolean isStrict() {
        return this.strictChecking;
    }

    @Override
    public void setStrict(boolean on) {
        this.strictChecking = on;
    }

    @Override
    public boolean isAutoCreationEnabled() {
        return this.autoCreate;
    }

    @Override
    public double getStep() {
        return this.step;
    }

    @Override
    public void setAutoCreate(boolean on) {
        this.autoCreate = on;
    }

    @Override
    public void stepBegins(double time) {
        this.listeners.sendStepBegins(time);
        this.step = time;
    }

    @Override
    public Viewer display() {
        return this.display(true);
    }

    @Override
    public Viewer display(boolean autoLayout) {
        try {
            Display display = Display.getDefault();
            return display.display(this, autoLayout);
        }
        catch (MissingDisplayException e) {
            throw new RuntimeException("Cannot launch viewer.", e);
        }
    }

    @Override
    public void clear() {
        this.listeners.sendGraphCleared();
        this.nodes().forEach(n -> ((AbstractNode)n).clearCallback());
        this.clearCallback();
        this.clearAttributesWithNoEvent();
    }

    @Override
    public Node addNode(String id) {
        AbstractNode node = (AbstractNode)this.getNode(id);
        if (node != null) {
            if (this.strictChecking) {
                throw new IdAlreadyInUseException("id \"" + id + "\" already in use. Cannot create a node.");
            }
            return node;
        }
        node = this.nodeFactory.newInstance(id, this);
        this.addNodeCallback(node);
        this.listeners.sendNodeAdded(id);
        return node;
    }

    @Override
    public Edge addEdge(String id, Node from, Node to, boolean directed) {
        return this.addEdge(id, (AbstractNode)from, from.getId(), (AbstractNode)to, to.getId(), directed);
    }

    @Override
    public Node removeNode(Node node) {
        if (node == null) {
            return null;
        }
        this.removeNode((AbstractNode)node, true);
        return node;
    }

    @Override
    public Edge removeEdge(Edge edge) {
        if (edge == null) {
            return null;
        }
        this.removeEdge((AbstractEdge)edge, true, true, true);
        return edge;
    }

    @Override
    public Edge removeEdge(Node node1, Node node2) {
        Edge edge = node1.getEdgeToward(node2);
        if (edge == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException("There is no edge from \"%s\" to \"%s\". Cannot remove it.", node1.getId(), node2.getId());
            }
            return null;
        }
        return this.removeEdge(edge);
    }

    @Override
    public Iterable<AttributeSink> attributeSinks() {
        return this.listeners.attributeSinks();
    }

    @Override
    public Iterable<ElementSink> elementSinks() {
        return this.listeners.elementSinks();
    }

    @Override
    public void addAttributeSink(AttributeSink sink) {
        this.listeners.addAttributeSink(sink);
    }

    @Override
    public void addElementSink(ElementSink sink) {
        this.listeners.addElementSink(sink);
    }

    @Override
    public void addSink(Sink sink) {
        this.listeners.addSink(sink);
    }

    @Override
    public void clearAttributeSinks() {
        this.listeners.clearAttributeSinks();
    }

    @Override
    public void clearElementSinks() {
        this.listeners.clearElementSinks();
    }

    @Override
    public void clearSinks() {
        this.listeners.clearSinks();
    }

    @Override
    public void removeAttributeSink(AttributeSink sink) {
        this.listeners.removeAttributeSink(sink);
    }

    @Override
    public void removeElementSink(ElementSink sink) {
        this.listeners.removeElementSink(sink);
    }

    @Override
    public void removeSink(Sink sink) {
        this.listeners.removeSink(sink);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.listeners.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.listeners.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.listeners.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.listeners.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.listeners.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.listeners.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.listeners.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.listeners.edgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.listeners.graphCleared(sourceId, timeId);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.listeners.stepBegins(sourceId, timeId, step);
    }

    @Override
    public Replayable.Controller getReplayController() {
        return new GraphReplayController();
    }

    protected abstract void addNodeCallback(AbstractNode var1);

    protected abstract void addEdgeCallback(AbstractEdge var1);

    protected abstract void removeNodeCallback(AbstractNode var1);

    protected abstract void removeEdgeCallback(AbstractEdge var1);

    protected abstract void clearCallback();

    protected Edge addEdge(String edgeId, AbstractNode src, String srcId, AbstractNode dst, String dstId, boolean directed) {
        AbstractEdge edge = (AbstractEdge)this.getEdge(edgeId);
        if (edge != null) {
            if (this.strictChecking) {
                throw new IdAlreadyInUseException("id \"" + edgeId + "\" already in use. Cannot create an edge.");
            }
            if (edge.getSourceNode() == src && edge.getTargetNode() == dst || !directed && edge.getTargetNode() == src && edge.getSourceNode() == dst) {
                return edge;
            }
            return null;
        }
        if (src == null || dst == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException(String.format("Cannot create edge %s[%s-%s%s]. Node '%s' does not exist.", edgeId, srcId, directed ? ">" : "-", dstId, src == null ? srcId : dstId), new Object[0]);
            }
            if (!this.autoCreate) {
                return null;
            }
            if (src == null) {
                src = (AbstractNode)this.addNode(srcId);
            }
            if (dst == null) {
                dst = (AbstractNode)this.addNode(dstId);
            }
        }
        if (!src.addEdgeCallback(edge = this.edgeFactory.newInstance(edgeId, src, dst, directed))) {
            if (this.strictChecking) {
                throw new EdgeRejectedException("Edge " + edge + " was rejected by node " + src);
            }
            return null;
        }
        if (src != dst && !dst.addEdgeCallback(edge)) {
            src.removeEdgeCallback(edge);
            if (this.strictChecking) {
                throw new EdgeRejectedException("Edge " + edge + " was rejected by node " + dst);
            }
            return null;
        }
        this.addEdgeCallback(edge);
        this.listeners.sendEdgeAdded(edgeId, srcId, dstId, directed);
        return edge;
    }

    private void removeAllEdges(AbstractNode node) {
        Collection toRemove = node.edges().collect(Collectors.toList());
        toRemove.forEach(this::removeEdge);
    }

    protected void removeNode(AbstractNode node, boolean graphCallback) {
        if (node == null) {
            return;
        }
        this.removeAllEdges(node);
        this.listeners.sendNodeRemoved(node.getId());
        if (graphCallback) {
            this.removeNodeCallback(node);
        }
    }

    protected void removeEdge(AbstractEdge edge, boolean graphCallback, boolean sourceCallback, boolean targetCallback) {
        if (edge == null) {
            return;
        }
        AbstractNode src = (AbstractNode)edge.getSourceNode();
        AbstractNode dst = (AbstractNode)edge.getTargetNode();
        this.listeners.sendEdgeRemoved(edge.getId());
        if (sourceCallback) {
            src.removeEdgeCallback(edge);
        }
        if (src != dst && targetCallback) {
            dst.removeEdgeCallback(edge);
        }
        if (graphCallback) {
            this.removeEdgeCallback(edge);
        }
    }

    class GraphReplayController
    extends SourceBase
    implements Replayable.Controller {
        GraphReplayController() {
            super(AbstractGraph.this.id + "replay");
        }

        @Override
        public void replay() {
            String sourceId = String.format("%s-replay-%x", AbstractGraph.this.id, AbstractGraph.this.replayId++);
            this.replay(sourceId);
        }

        @Override
        public void replay(String sourceId) {
            int i;
            AbstractGraph.this.attributeKeys().forEach(key -> this.sendGraphAttributeAdded(sourceId, (String)key, AbstractGraph.this.getAttribute((String)key)));
            for (i = 0; i < AbstractGraph.this.getNodeCount(); ++i) {
                Node node = AbstractGraph.this.getNode(i);
                String nodeId = node.getId();
                this.sendNodeAdded(sourceId, nodeId);
                node.attributeKeys().forEach(key -> this.sendNodeAttributeAdded(sourceId, nodeId, (String)key, node.getAttribute((String)key)));
            }
            for (i = 0; i < AbstractGraph.this.getEdgeCount(); ++i) {
                Edge edge = AbstractGraph.this.getEdge(i);
                String edgeId = edge.getId();
                this.sendEdgeAdded(sourceId, edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
                edge.attributeKeys().forEach(key -> this.sendEdgeAttributeAdded(sourceId, edgeId, (String)key, edge.getAttribute((String)key)));
            }
        }
    }
}

