/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class BreadthFirstIterator
implements Iterator<Node> {
    protected boolean directed;
    protected Graph graph;
    protected Node[] queue;
    protected int[] depth;
    protected int qHead;
    protected int qTail;

    public BreadthFirstIterator(Node startNode, boolean directed) {
        this.directed = directed;
        this.graph = startNode.getGraph();
        int n = this.graph.getNodeCount();
        this.queue = new Node[n];
        this.depth = new int[n];
        int s = startNode.getIndex();
        for (int i = 0; i < n; ++i) {
            this.depth[i] = i == s ? 0 : -1;
        }
        this.queue[0] = startNode;
        this.qHead = 0;
        this.qTail = 1;
    }

    public BreadthFirstIterator(Node startNode) {
        this(startNode, true);
    }

    @Override
    public boolean hasNext() {
        return this.qHead < this.qTail;
    }

    @Override
    public Node next() {
        if (this.qHead >= this.qTail) {
            throw new NoSuchElementException();
        }
        Node current = this.queue[this.qHead++];
        int level = this.depth[current.getIndex()] + 1;
        Stream<Edge> edges = this.directed ? current.leavingEdges() : current.edges();
        edges.forEach(e -> {
            Node node = e.getOpposite(current);
            int j = node.getIndex();
            if (this.depth[j] == -1) {
                this.queue[this.qTail++] = node;
                this.depth[j] = level;
            }
        });
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support remove");
    }

    public int getDepthOf(Node node) {
        return this.depth[node.getIndex()];
    }

    public int getDepthMax() {
        return this.depth[this.queue[this.qTail - 1].getIndex()];
    }

    public boolean tabu(Node node) {
        return this.depth[node.getIndex()] != -1;
    }

    public boolean isDirected() {
        return this.directed;
    }
}

