/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.util;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Class<?> getSuper(Class<?> ... classes) {
        return TypeUtils.getSuper(false, classes);
    }

    public static Class<?> getSuper(boolean autobox, Class<?> ... classes) {
        block0: for (Class<?> cls1 : classes) {
            for (Class<?> cls2 : classes) {
                if (!ClassUtils.isAssignable(cls2, cls1, (boolean)autobox)) continue block0;
            }
            return cls1;
        }
        return null;
    }

    public static Class<?> getSub(Class<?> ... classes) {
        return TypeUtils.getSuper(false, classes);
    }

    public static Class<?> getSub(boolean autobox, Class<?> ... classes) {
        block0: for (Class<?> cls1 : classes) {
            for (Class<?> cls2 : classes) {
                if (!ClassUtils.isAssignable(cls1, cls2, (boolean)autobox)) continue block0;
            }
            return cls1;
        }
        return null;
    }

    public static boolean containsSub(Class<?>[] collection, Class<?> cls) {
        for (Class<?> c : collection) {
            if (!ClassUtils.isAssignable(c, cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSuper(Class<?>[] collection, Class<?> cls) {
        for (Class<?> c : collection) {
            if (!ClassUtils.isAssignable(cls, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean allSub(Class<?>[] collection, Class<?> cls) {
        for (Class<?> c : collection) {
            if (ClassUtils.isAssignable(c, cls)) continue;
            return false;
        }
        return true;
    }

    public static boolean allSuper(Class<?>[] collection, Class<?> cls) {
        for (Class<?> c : collection) {
            if (ClassUtils.isAssignable(cls, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean allEqual(Class<?>[] collection, Class<?> cls) {
        for (Class<?> c : collection) {
            if (c == cls) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getNumericType(Class<?> ... classes) {
        if (!TypeUtils.isAllNumericType(classes)) {
            return null;
        }
        if (ArrayUtils.contains((Object[])classes, Double.class)) {
            return Double.class;
        }
        if (ArrayUtils.contains((Object[])classes, Float.class)) {
            return Float.class;
        }
        if (ArrayUtils.contains((Object[])classes, Long.class)) {
            return Long.class;
        }
        return Integer.class;
    }

    public static boolean isIntegerType(Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class;
    }

    public static boolean isNumericType(Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Double.class || type == Float.class;
    }

    public static boolean isAllNumericType(Class<?>[] classes) {
        for (Class<?> c : classes) {
            if (TypeUtils.isNumericType(c)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (Integer.class.equals(type)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type)) {
            return Long.TYPE;
        }
        if (Float.class.equals(type)) {
            return Float.TYPE;
        }
        if (Double.class.equals(type)) {
            return Double.TYPE;
        }
        if (Byte.class.equals(type)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(type)) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException("Input class must be a numeric type");
    }

    public static Class<?> getWrapperType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }
}

