/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.util;

public final class BoolUtils {
    private BoolUtils() {
    }

    public static boolean[] toArray(String input) {
        int len = input.length();
        boolean[] bools = new boolean[len];
        for (int i = 0; i < len; ++i) {
            bools[i] = input.charAt(i) == '1';
        }
        return bools;
    }

    public static boolean[][] generateBoolSequences(int noBits) {
        int noInputs = (int)Math.pow(2.0, noBits);
        boolean[][] inputs = new boolean[noInputs][noBits];
        for (int i = 0; i < noBits; ++i) {
            int rep = (int)Math.pow(2.0, i + 1);
            for (int j = 0; j < noInputs; ++j) {
                inputs[j][i] = (double)(j % rep) > Math.floor(rep / 2) - 1.0;
            }
        }
        return inputs;
    }

    public static boolean[] generateBoolSequence(int noBits, long index) {
        boolean[] inputs = new boolean[noBits];
        for (int i = 0; i < noBits; ++i) {
            int rep = (int)Math.pow(2.0, i + 1);
            inputs[i] = (double)(index % (long)rep) > Math.floor(rep / 2) - 1.0;
        }
        return inputs;
    }
}

