/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.grammar;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.epochx.tools.grammar.GrammarRule;
import org.epochx.tools.grammar.Symbol;
import org.epochx.tools.grammar.TerminalSymbol;

public class NonTerminalSymbol
implements Symbol {
    private List<Symbol> children;
    private GrammarRule grammarRule;

    public NonTerminalSymbol(GrammarRule grammarRule) {
        this(grammarRule, new ArrayList<Symbol>());
    }

    public NonTerminalSymbol(GrammarRule grammarRule, List<Symbol> children) {
        this.grammarRule = grammarRule;
        this.children = children;
    }

    public void setChild(int index, Symbol child) {
        this.children.set(index, child);
    }

    public Symbol getChild(int index) {
        return this.children.get(index);
    }

    public void addChild(Symbol child) {
        this.children.add(child);
    }

    public List<Symbol> removeChildren() {
        this.children.clear();
        return this.children;
    }

    public Symbol removeChild(int index) {
        return this.children.remove(index);
    }

    public List<Symbol> getChildren() {
        return this.children;
    }

    public void setChildren(List<Symbol> newChildren) {
        this.children = newChildren;
    }

    public int getNoNonTerminalSymbols() {
        int noNonTerminals = 1;
        for (Symbol child : this.children) {
            if (!(child instanceof NonTerminalSymbol)) continue;
            noNonTerminals += ((NonTerminalSymbol)child).getNoNonTerminalSymbols();
        }
        assert (noNonTerminals >= 1);
        return noNonTerminals;
    }

    public int getNoNonTerminalSymbols(GrammarRule rule) {
        int noNonTerminals = 0;
        if (this.getGrammarRule().equals(rule)) {
            ++noNonTerminals;
        }
        for (Symbol child : this.children) {
            if (!(child instanceof NonTerminalSymbol)) continue;
            noNonTerminals += ((NonTerminalSymbol)child).getNoNonTerminalSymbols(rule);
        }
        return noNonTerminals;
    }

    public int getNoTerminalSymbols() {
        int noTerminals = 0;
        for (Symbol child : this.children) {
            if (child instanceof TerminalSymbol) {
                ++noTerminals;
                continue;
            }
            if (!(child instanceof NonTerminalSymbol)) continue;
            noTerminals += ((NonTerminalSymbol)child).getNoTerminalSymbols();
        }
        return noTerminals;
    }

    public int getNoSymbols() {
        int noSymbols = 1;
        for (Symbol child : this.children) {
            if (child instanceof TerminalSymbol) {
                ++noSymbols;
                continue;
            }
            if (!(child instanceof NonTerminalSymbol)) continue;
            noSymbols += ((NonTerminalSymbol)child).getNoSymbols();
        }
        return noSymbols;
    }

    public int getNoChildren() {
        return this.children.size();
    }

    public NonTerminalSymbol removeNthNonTerminal(int n) {
        return this.removeNthNonTerminal(n, 0, null);
    }

    private NonTerminalSymbol removeNthNonTerminal(int n, int current, GrammarRule rule) {
        for (int i = 0; i < this.children.size(); ++i) {
            Symbol child = this.children.get(i);
            if (!(child instanceof NonTerminalSymbol)) continue;
            NonTerminalSymbol nt = (NonTerminalSymbol)child;
            boolean valid = false;
            if (rule == null || rule.equals(nt.getGrammarRule())) {
                valid = true;
            }
            if (valid && n == current + 1) {
                return (NonTerminalSymbol)this.removeChild(i);
            }
            NonTerminalSymbol nth = nt.removeNthNonTerminal(n, valid ? current + 1 : current, rule);
            if (nth != null) {
                return nth;
            }
            current += nt.getNoNonTerminalSymbols(rule);
        }
        return null;
    }

    public NonTerminalSymbol removeNthNonTerminal(int n, GrammarRule grammarRule) {
        return this.removeNthNonTerminal(n, 0, grammarRule);
    }

    public NonTerminalSymbol getNthNonTerminal(int n) {
        return this.getNthNonTerminal(n, 0);
    }

    private NonTerminalSymbol getNthNonTerminal(int n, int current) {
        if (n == current) {
            return this;
        }
        for (Symbol child : this.children) {
            if (!(child instanceof NonTerminalSymbol)) continue;
            NonTerminalSymbol nt = (NonTerminalSymbol)child;
            NonTerminalSymbol nth = nt.getNthNonTerminal(n, current + 1);
            if (nth != null) {
                return nth;
            }
            current += nt.getNoNonTerminalSymbols();
        }
        return null;
    }

    public TerminalSymbol getNthTerminal(int n) {
        List<TerminalSymbol> terminals = this.getTerminalSymbols();
        return terminals.get(n);
    }

    public Symbol getNthSymbol(int n) {
        return this.getNthSymbol(n, 0);
    }

    private Symbol getNthSymbol(int n, int current) {
        if (n == current) {
            return this;
        }
        for (Symbol child : this.children) {
            if (child instanceof NonTerminalSymbol) {
                NonTerminalSymbol nt = (NonTerminalSymbol)child;
                Symbol nth = nt.getNthSymbol(n, current + 1);
                if (nth != null) {
                    return nth;
                }
                current += nt.getNoSymbols();
                continue;
            }
            if (n != ++current) continue;
            return child;
        }
        return null;
    }

    public void setNthSymbol(int n, Symbol newSymbol) {
        this.setNthSymbol(n, newSymbol, 0);
    }

    private void setNthSymbol(int n, Symbol symbol, int current) {
        int noChildren = this.getNoChildren();
        for (int i = 0; i < noChildren; ++i) {
            if (current + 1 == n) {
                this.setChild(i, symbol);
                break;
            }
            if (this.children.get(i) instanceof NonTerminalSymbol) {
                NonTerminalSymbol child = (NonTerminalSymbol)this.children.get(i);
                int noChildSymbols = child.getNoSymbols();
                if (n <= current + noChildSymbols) {
                    child.setNthSymbol(n, symbol, current + 1);
                }
                current += noChildSymbols;
                continue;
            }
            ++current;
        }
    }

    public List<NonTerminalSymbol> getNonTerminalSymbols() {
        ArrayList<NonTerminalSymbol> nonTerminals = new ArrayList<NonTerminalSymbol>();
        nonTerminals.add(this);
        for (Symbol child : this.children) {
            if (!(child instanceof NonTerminalSymbol)) continue;
            nonTerminals.addAll(((NonTerminalSymbol)child).getNonTerminalSymbols());
        }
        return nonTerminals;
    }

    public List<Integer> getNonTerminalIndexes() {
        return this.getNonTerminalIndexes(0);
    }

    private List<Integer> getNonTerminalIndexes(int index) {
        ArrayList<Integer> nonTerminals = new ArrayList<Integer>();
        nonTerminals.add(index);
        for (Symbol child : this.children) {
            if (child instanceof NonTerminalSymbol) {
                NonTerminalSymbol nt = (NonTerminalSymbol)child;
                nonTerminals.addAll(nt.getNonTerminalIndexes(index + 1));
                index += nt.getNoSymbols();
                continue;
            }
            ++index;
        }
        return nonTerminals;
    }

    public List<TerminalSymbol> getTerminalSymbols() {
        ArrayList<TerminalSymbol> terminals = new ArrayList<TerminalSymbol>();
        for (Symbol child : this.children) {
            if (child instanceof TerminalSymbol) {
                terminals.add((TerminalSymbol)child);
                continue;
            }
            if (!(child instanceof NonTerminalSymbol)) continue;
            terminals.addAll(((NonTerminalSymbol)child).getTerminalSymbols());
        }
        return terminals;
    }

    public List<Symbol> getAllSymbols() {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        symbols.add(this);
        for (Symbol child : this.children) {
            if (child instanceof TerminalSymbol) {
                symbols.add(child);
                continue;
            }
            if (!(child instanceof NonTerminalSymbol)) continue;
            symbols.addAll(((NonTerminalSymbol)child).getAllSymbols());
        }
        return symbols;
    }

    public GrammarRule getGrammarRule() {
        return this.grammarRule;
    }

    public int getDepth() {
        int maxChildDepth = 0;
        for (Symbol child : this.children) {
            int childDepth = child instanceof NonTerminalSymbol ? ((NonTerminalSymbol)child).getDepth() + 1 : 1;
            if (childDepth <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.children.size());
        for (Symbol c : this.children) {
            buffer.append(c.toString());
        }
        return buffer.toString();
    }

    @Override
    public NonTerminalSymbol clone() {
        NonTerminalSymbol clone;
        block3: {
            clone = null;
            try {
                clone = (NonTerminalSymbol)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        clone.children = new ArrayList<Symbol>();
        for (Symbol c : this.children) {
            clone.children.add(c.clone());
        }
        clone.grammarRule = this.grammarRule;
        return clone;
    }

    public boolean equals(Object obj) {
        boolean equal = true;
        if (obj != null && obj instanceof NonTerminalSymbol) {
            NonTerminalSymbol otherSymbol = (NonTerminalSymbol)obj;
            if (this.getGrammarRule() == otherSymbol.getGrammarRule()) {
                for (int i = 0; i < this.children.size(); ++i) {
                    Symbol thatChild = otherSymbol.getChild(i);
                    Symbol thisChild = this.getChild(i);
                    if (ObjectUtils.equals((Object)thisChild, (Object)thatChild)) continue;
                    equal = false;
                    break;
                }
            } else {
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }
}

