/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.grammar;

import java.util.ArrayList;
import java.util.List;
import org.epochx.tools.grammar.GrammarNode;
import org.epochx.tools.grammar.GrammarProduction;

public class GrammarRule
implements GrammarNode,
Cloneable {
    private final List<GrammarProduction> productions;
    private String name;
    private boolean recursive;
    private int minDepth;

    public GrammarRule(String name, List<GrammarProduction> productions) {
        this.name = name;
        this.productions = productions;
    }

    public GrammarRule(String name) {
        this(name, new ArrayList<GrammarProduction>());
    }

    public GrammarRule() {
        this(null);
    }

    public void addProduction(GrammarProduction production) {
        this.productions.add(production);
    }

    public void addProduction(int index, GrammarProduction production) {
        this.productions.add(index, production);
    }

    public void setProduction(int index, GrammarProduction production) {
        this.productions.set(index, production);
    }

    public GrammarProduction getProduction(int index) {
        return this.productions.get(index);
    }

    public List<GrammarProduction> getProductions() {
        return this.productions;
    }

    public int getNoProductions() {
        return this.productions.size();
    }

    public String getName() {
        return this.name;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public GrammarRule clone() {
        GrammarRule clone = null;
        try {
            clone = (GrammarRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.name = this.name;
        clone.recursive = this.recursive;
        clone.minDepth = this.minDepth;
        for (GrammarProduction p : this.productions) {
            clone.productions.add(p.clone());
        }
        return clone;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        buffer.append(this.name);
        buffer.append('>');
        buffer.append(" ::= ");
        for (int i = 0; i < this.productions.size(); ++i) {
            if (i > 0) {
                buffer.append(" | ");
            }
            buffer.append(this.productions.get(i).toString());
        }
        return buffer.toString();
    }
}

