/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.grammar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.epochx.tools.grammar.GrammarLiteral;
import org.epochx.tools.grammar.GrammarNode;
import org.epochx.tools.grammar.GrammarRule;

public class GrammarProduction
implements Cloneable {
    private final List<GrammarNode> grammarNodes;
    private final Map<String, Object> attributes;

    public GrammarProduction(List<GrammarNode> grammarNodes) {
        this.grammarNodes = grammarNodes;
        this.attributes = new HashMap<String, Object>();
    }

    public GrammarProduction() {
        this(new ArrayList<GrammarNode>());
    }

    public void addGrammarNode(GrammarNode node) {
        this.grammarNodes.add(node);
    }

    public List<GrammarNode> getGrammarNodes() {
        return this.grammarNodes;
    }

    public GrammarNode getGrammarNode(int index) {
        return this.grammarNodes.get(index);
    }

    public void setGrammarNode(int index, GrammarNode node) {
        this.grammarNodes.set(index, node);
    }

    public void addGrammarNode(int index, GrammarNode node) {
        this.grammarNodes.add(index, node);
    }

    public int getNoGrammarNodes() {
        return this.grammarNodes.size();
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public int getMinDepth() {
        int max = 0;
        for (GrammarNode s : this.grammarNodes) {
            int d = 0;
            if (s instanceof GrammarRule) {
                d = ((GrammarRule)s).getMinDepth();
            }
            if (d <= max) continue;
            max = d;
        }
        return max;
    }

    public boolean isRecursive() {
        boolean recursive = false;
        for (GrammarNode s : this.grammarNodes) {
            if (s instanceof GrammarRule) {
                recursive = ((GrammarRule)s).isRecursive();
            }
            if (!recursive) continue;
            break;
        }
        return recursive;
    }

    public GrammarProduction clone() {
        GrammarProduction clone = null;
        try {
            clone = (GrammarProduction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.grammarNodes.addAll(this.grammarNodes);
        clone.attributes.putAll(this.attributes);
        return clone;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (GrammarNode s : this.grammarNodes) {
            if (s instanceof GrammarLiteral) {
                buffer.append(((GrammarLiteral)s).toString());
            }
            if (s instanceof GrammarRule) {
                buffer.append('<');
                buffer.append(((GrammarRule)s).getName());
                buffer.append('>');
            }
            buffer.append(' ');
        }
        if (this.attributes.size() > 0) {
            buffer.append("<?");
            Set<String> keys = this.attributes.keySet();
            int i = 0;
            for (String k : keys) {
                if (i != 0) {
                    buffer.append(';');
                }
                buffer.append(k);
                buffer.append('=');
                buffer.append(this.attributes.get(k));
                ++i;
            }
            buffer.append("?>");
        }
        return buffer.toString();
    }
}

