/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.grammar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.epochx.tools.grammar.GrammarLiteral;
import org.epochx.tools.grammar.GrammarNode;
import org.epochx.tools.grammar.GrammarProduction;
import org.epochx.tools.grammar.GrammarRule;
import org.epochx.tools.grammar.MalformedGrammarException;

public class Grammar {
    private final Map<String, GrammarLiteral> literals;
    private final Map<String, GrammarRule> rules;
    private GrammarRule start;

    public Grammar(String grammarStr) {
        this.literals = new HashMap<String, GrammarLiteral>();
        this.rules = new HashMap<String, GrammarRule>();
        this.parseGrammar(grammarStr);
    }

    public Grammar(File grammarFile) throws IOException {
        String grammar = this.readGrammarFile(grammarFile);
        this.literals = new HashMap<String, GrammarLiteral>();
        this.rules = new HashMap<String, GrammarRule>();
        this.parseGrammar(grammar);
    }

    public GrammarRule getStartRule() {
        return this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readGrammarFile(File grammarFile) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(grammarFile));
        StringBuilder grammarStr = new StringBuilder();
        String line = null;
        try {
            while ((line = input.readLine()) != null) {
                grammarStr.append(line);
                grammarStr.append(System.getProperty("line.separator"));
            }
        }
        finally {
            input.close();
        }
        return grammarStr.toString();
    }

    protected void parseGrammar(String grammar) {
        State state = State.START;
        StringBuilder buffer = new StringBuilder();
        GrammarRule lhs = null;
        GrammarProduction grammarProduction = new GrammarProduction();
        boolean quoted = false;
        boolean terminal = true;
        boolean special = false;
        grammar = grammar + '\n';
        block7: for (int i = 0; i < grammar.length(); ++i) {
            char ch = grammar.charAt(i);
            if (grammar.charAt(i) == '\\') {
                if (++i >= grammar.length()) {
                    throw new MalformedGrammarException("Escape sequence as last char is invalid");
                }
                if (!terminal && grammar.charAt(i) != '\n') {
                    throw new MalformedGrammarException("Only escaped newline allowed inside non-terminal");
                }
                boolean skip = false;
                if (grammar.charAt(i) == '\'') {
                    ch = '\'';
                } else if (grammar.charAt(i) == '\'') {
                    ch = '\'';
                } else if (grammar.charAt(i) == '\\') {
                    ch = '\\';
                } else if (grammar.charAt(i) == '0') {
                    ch = '\u0000';
                } else if (grammar.charAt(i) == 'a') {
                    ch = '\u0007';
                } else if (grammar.charAt(i) == 'b') {
                    ch = '\b';
                } else if (grammar.charAt(i) == 'f') {
                    ch = '\f';
                } else if (grammar.charAt(i) == 'n') {
                    ch = '\n';
                } else if (grammar.charAt(i) == 'r') {
                    ch = '\r';
                } else if (grammar.charAt(i) == 't') {
                    ch = '\t';
                } else if (grammar.charAt(i) == 'v') {
                    ch = '\u000b';
                } else if (grammar.charAt(i) == '\n') {
                    skip = true;
                } else if (grammar.charAt(i) == '\r') {
                    skip = true;
                    if (grammar.charAt(++i) != '\n') {
                        throw new MalformedGrammarException("No newline");
                    }
                } else {
                    ch = grammar.charAt(i);
                }
                if (skip) continue;
                buffer.append(ch);
                continue;
            }
            switch (state) {
                case START: {
                    if (ch == '\r') continue block7;
                    if (ch == '#') {
                        while (i < grammar.length() && grammar.charAt(i) != '\n') {
                            ++i;
                        }
                        continue block7;
                    }
                    if (ch == ' ' || ch == '\t' || ch == '\n') continue block7;
                    if (ch == '<') {
                        state = State.START_RULE;
                        continue block7;
                    }
                    throw new MalformedGrammarException("Illegal character: " + ch);
                }
                case START_RULE: {
                    if (ch == '\r') continue block7;
                    if (ch == '\n') {
                        throw new MalformedGrammarException("Misplaced newline");
                    }
                    if (ch == '>') {
                        String symbolName = buffer.toString();
                        if (!this.rules.containsKey(symbolName)) {
                            lhs = new GrammarRule(symbolName);
                            this.rules.put(symbolName, lhs);
                        } else {
                            lhs = this.rules.get(symbolName);
                            if (lhs.getNoProductions() > 0) {
                                throw new MalformedGrammarException("Duplicate rule: " + symbolName);
                            }
                        }
                        if (this.start == null) {
                            this.start = lhs;
                        }
                        buffer = new StringBuilder();
                        state = State.LHS_READ;
                        continue block7;
                    }
                    if (ch == '\"' || ch == '|' || ch == '<') {
                        throw new MalformedGrammarException("Non-escaped special char: " + ch);
                    }
                    buffer.append(ch);
                    continue block7;
                }
                case LHS_READ: {
                    if (ch == '\r' || ch == ' ' || ch == '\t' || ch == '\n') continue block7;
                    if (ch == ':') {
                        buffer.append(ch);
                        continue block7;
                    }
                    if (ch == '=') {
                        buffer.append(ch);
                        if (!buffer.toString().equals("::=")) {
                            throw new MalformedGrammarException("Expected '::=' but found: " + buffer.toString());
                        }
                        buffer = new StringBuilder();
                        state = State.PRODUCTION;
                        continue block7;
                    }
                    throw new MalformedGrammarException("Illegal character: " + ch);
                }
                case PRODUCTION: {
                    GrammarNode newSymbol;
                    if (ch == '\r') continue block7;
                    if (ch == '|' && quoted) {
                        buffer.append(ch);
                        continue block7;
                    }
                    if (ch == '\n' || ch == '|') {
                        if (buffer.length() != 0) {
                            String symbolName = buffer.toString();
                            if (terminal) {
                                newSymbol = this.literals.get(symbolName);
                                if (newSymbol == null) {
                                    newSymbol = new GrammarLiteral(symbolName);
                                    this.literals.put(symbolName, (GrammarLiteral)newSymbol);
                                }
                            } else {
                                throw new MalformedGrammarException("Unterminated non-terminal");
                            }
                            grammarProduction.addGrammarNode(newSymbol);
                            buffer = new StringBuilder();
                        }
                        lhs.addProduction(grammarProduction);
                        grammarProduction = new GrammarProduction();
                        if (ch != 10) continue block7;
                        state = State.START_OF_LINE;
                        continue block7;
                    }
                    if (ch == '<') {
                        if (quoted) {
                            buffer.append(ch);
                            continue block7;
                        }
                        if (buffer.length() == 0) {
                            terminal = false;
                            continue block7;
                        }
                        throw new MalformedGrammarException("Non-escaped special char: " + ch + "-->" + buffer.toString());
                    }
                    if (ch == '?') {
                        if (special) {
                            String specialCommand = buffer.toString().trim();
                            this.processSpecialRule(specialCommand, grammarProduction);
                            continue block7;
                        }
                        if (!terminal) {
                            special = true;
                            continue block7;
                        }
                        buffer.append(ch);
                        continue block7;
                    }
                    if (ch == '>') {
                        if (quoted) {
                            buffer.append(ch);
                            continue block7;
                        }
                        if (special) {
                            special = false;
                            terminal = true;
                            buffer = new StringBuilder();
                            continue block7;
                        }
                        if (!terminal) {
                            String symbolName = buffer.toString();
                            newSymbol = this.rules.get(symbolName);
                            if (newSymbol == null) {
                                newSymbol = new GrammarRule(symbolName);
                                this.rules.put(symbolName, (GrammarRule)newSymbol);
                            }
                            grammarProduction.addGrammarNode(newSymbol);
                            terminal = true;
                            buffer = new StringBuilder();
                            continue block7;
                        }
                        throw new MalformedGrammarException("Non-escaped special char: " + ch);
                    }
                    if (ch == ' ' || ch == '\t') {
                        if (quoted || !terminal) {
                            buffer.append(ch);
                            continue block7;
                        }
                        if (buffer.length() == 0) continue block7;
                        String symbolName = buffer.toString();
                        newSymbol = this.literals.get(symbolName);
                        if (newSymbol == null) {
                            newSymbol = new GrammarLiteral(symbolName);
                            this.literals.put(symbolName, (GrammarLiteral)newSymbol);
                        }
                        grammarProduction.addGrammarNode(newSymbol);
                        buffer = new StringBuilder();
                        continue block7;
                    }
                    if (ch == '\"') {
                        quoted = !quoted;
                        continue block7;
                    }
                    buffer.append(ch);
                    continue block7;
                }
                case START_OF_LINE: {
                    if (ch == '#') {
                        while (i < grammar.length() && grammar.charAt(i) != '\n') {
                            ++i;
                        }
                        continue block7;
                    }
                    if (ch == '\r' || ch == ' ' || ch == '\t' || ch == '\n') continue block7;
                    if (ch == '|') {
                        state = State.PRODUCTION;
                        continue block7;
                    }
                    if (ch == '<') {
                        state = State.START_RULE;
                        continue block7;
                    }
                    throw new MalformedGrammarException("Illegal character: " + ch);
                }
                default: {
                    throw new MalformedGrammarException("Impossible error, quit program now.");
                }
            }
        }
        this.setRecursiveness();
        if (this.start == null) {
            throw new MalformedGrammarException("No valid rules found in grammar string");
        }
        Collection<GrammarRule> ruleList = this.rules.values();
        for (GrammarRule rule : ruleList) {
            rule.setMinDepth(this.getMinDepth(new ArrayList<GrammarRule>(), rule));
            if (rule.getNoProductions() == 0) {
                System.out.println(rule.toString());
                throw new MalformedGrammarException("Grammar rule " + rule.getName() + " has no productions");
            }
            if (!this.isInfinitelyRecursive(rule)) continue;
            throw new MalformedGrammarException("Grammar rule " + rule.getName() + " is infinitely recursive");
        }
    }

    protected boolean isInfinitelyRecursive(GrammarRule rule) {
        return rule.isRecursive() && this.isInfinitelyRecursive(rule, rule, new ArrayList<GrammarRule>());
    }

    private boolean isInfinitelyRecursive(GrammarRule rule, GrammarRule currentRule, List<GrammarRule> path) {
        path.add(currentRule);
        boolean ref = true;
        List<GrammarProduction> productions = currentRule.getProductions();
        block0: for (GrammarProduction p : productions) {
            List<GrammarNode> nodes = p.getGrammarNodes();
            if (nodes.contains(rule)) continue;
            for (GrammarNode n : nodes) {
                GrammarRule r;
                if (!(n instanceof GrammarRule) || !path.contains(r = (GrammarRule)n) && !this.isInfinitelyRecursive(rule, r, path)) continue;
                continue block0;
            }
            ref = false;
            break;
        }
        path.remove(path.size() - 1);
        return ref;
    }

    private void setRecursiveness() {
        if (this.start instanceof GrammarRule) {
            this.setRecursiveness(new ArrayList<GrammarRule>(), this.start);
        }
    }

    private void setRecursiveness(List<GrammarRule> path, GrammarRule current) {
        if (path.contains(current)) {
            for (GrammarRule s : path) {
                s.setRecursive(true);
            }
        } else {
            path.add(current);
            for (int i = 0; i < current.getNoProductions(); ++i) {
                GrammarProduction p = current.getProduction(i);
                for (int j = 0; j < p.getNoGrammarNodes(); ++j) {
                    if (!(p.getGrammarNode(j) instanceof GrammarRule)) continue;
                    GrammarRule nt = (GrammarRule)p.getGrammarNode(j);
                    this.setRecursiveness(new ArrayList<GrammarRule>(path), nt);
                }
            }
        }
    }

    private void processSpecialRule(String command, GrammarProduction production) {
        String[] commands;
        for (String c : commands = command.split(";")) {
            String[] keyAndValue = c.split("=");
            production.setAttribute(keyAndValue[0], keyAndValue[1]);
        }
    }

    private int getMinDepth(List<GrammarRule> path, GrammarNode currentSymbol) {
        if (!(currentSymbol instanceof GrammarRule)) {
            return 0;
        }
        GrammarRule current = (GrammarRule)currentSymbol;
        if (path.contains(current)) {
            return Integer.MAX_VALUE;
        }
        path.add(current);
        int minDepth = Integer.MAX_VALUE;
        for (int i = 0; i < current.getNoProductions(); ++i) {
            GrammarProduction p = current.getProduction(i);
            int productionsMinDepth = -1;
            for (int j = 0; j < p.getNoGrammarNodes(); ++j) {
                int d = this.getMinDepth(new ArrayList<GrammarRule>(path), p.getGrammarNode(j));
                if (d <= productionsMinDepth) continue;
                productionsMinDepth = d;
            }
            if (productionsMinDepth >= minDepth) continue;
            minDepth = productionsMinDepth;
        }
        if (minDepth != Integer.MAX_VALUE) {
            ++minDepth;
        }
        return minDepth;
    }

    public List<GrammarLiteral> getGrammarLiterals() {
        return new ArrayList<GrammarLiteral>(this.literals.values());
    }

    public GrammarLiteral getGrammarLiteral(String name) {
        return this.literals.get(name);
    }

    public List<GrammarRule> getGrammarRules() {
        return new ArrayList<GrammarRule>(this.rules.values());
    }

    public GrammarRule getGrammarRule(String name) {
        return this.rules.get(name);
    }

    public int getMinimumDepth() {
        assert (this.start != null);
        return this.start.getMinDepth();
    }

    private static enum State {
        START,
        START_RULE,
        LHS_READ,
        PRODUCTION,
        START_OF_LINE;

    }
}

