/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.eval;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.epochx.tools.eval.Interpreter;
import org.epochx.tools.eval.MalformedProgramException;

public class ScriptingInterpreter
implements Interpreter {
    private final ScriptEngine engine;

    public ScriptingInterpreter(String engineName) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(engineName);
        if (this.engine == null) {
            throw new IllegalArgumentException("no engine matching alias " + engineName);
        }
    }

    public ScriptingInterpreter(ScriptEngine engine) {
        this.engine = engine;
    }

    @Override
    public Object eval(String expression, String[] argNames, Object[] argValues) throws MalformedProgramException {
        Object result = null;
        try {
            for (int i = 0; i < argNames.length; ++i) {
                this.engine.put(argNames[i], argValues[i]);
            }
            result = this.engine.eval(expression);
        }
        catch (ScriptException e) {
            throw new MalformedProgramException();
        }
        return result;
    }

    @Override
    public Object[] eval(String expression, String[] argNames, Object[][] argValues) throws MalformedProgramException {
        Object[] results = new Object[argValues.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.eval(expression, argNames, argValues[i]);
        }
        return results;
    }

    @Override
    public void exec(String program, String[] argNames, Object[] argValues) throws MalformedProgramException {
        this.eval(program, argNames, argValues);
    }

    @Override
    public void exec(String program, String[] argNames, Object[][] argValues) throws MalformedProgramException {
        for (int i = 0; i < argValues.length; ++i) {
            this.exec(program, argNames, argValues[i]);
        }
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }
}

