/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.eval;

import javax.script.Invocable;
import javax.script.ScriptException;
import org.epochx.tools.eval.MalformedProgramException;
import org.epochx.tools.eval.ScriptingInterpreter;

public class RubyInterpreter
extends ScriptingInterpreter {
    public RubyInterpreter() {
        super("ruby");
    }

    @Override
    public Object eval(String expression, String[] argNames, Object[] argValues) throws MalformedProgramException {
        String code = this.getEvalCode(expression, argNames);
        Object result = null;
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            result = invocableEngine.invokeFunction("expr", argValues);
        }
        catch (ScriptException ex) {
            throw new MalformedProgramException();
        }
        catch (NoSuchMethodException ex) {
            throw new MalformedProgramException();
        }
        return result;
    }

    @Override
    public Object[] eval(String expression, String[] argNames, Object[][] argValues) throws MalformedProgramException {
        Object[] results = new Object[argValues.length];
        String code = this.getEvalCode(expression, argNames);
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            for (int i = 0; i < results.length; ++i) {
                results[i] = invocableEngine.invokeFunction("expr", argValues[i]);
            }
        }
        catch (ScriptException ex) {
            throw new MalformedProgramException();
        }
        catch (NoSuchMethodException ex) {
            throw new MalformedProgramException();
        }
        return results;
    }

    @Override
    public void exec(String program, String[] argNames, Object[] argValues) throws MalformedProgramException {
        String code = this.getExecCode(program, argNames);
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            invocableEngine.invokeFunction("expr", argValues);
        }
        catch (ScriptException ex) {
            throw new MalformedProgramException();
        }
        catch (NoSuchMethodException ex) {
            throw new MalformedProgramException();
        }
    }

    @Override
    public void exec(String program, String[] argNames, Object[][] argValues) throws MalformedProgramException {
        String code = this.getExecCode(program, argNames);
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            for (int i = 0; i < argValues.length; ++i) {
                invocableEngine.invokeFunction("expr", argValues[i]);
            }
        }
        catch (ScriptException ex) {
            throw new MalformedProgramException();
        }
        catch (NoSuchMethodException ex) {
            throw new MalformedProgramException();
        }
    }

    private String getEvalCode(String expression, String[] argNames) {
        StringBuffer code = new StringBuffer();
        code.append("def expr(");
        for (int i = 0; i < argNames.length; ++i) {
            if (i > 0) {
                code.append(',');
            }
            code.append(argNames[i]);
        }
        code.append(")\n");
        code.append("return ");
        code.append(expression);
        code.append(";\n");
        code.append("end\n");
        return code.toString();
    }

    private String getExecCode(String program, String[] argNames) {
        StringBuffer code = new StringBuffer();
        code.append("def expr(");
        for (int i = 0; i < argNames.length; ++i) {
            if (i > 0) {
                code.append(',');
            }
            code.append(argNames[i]);
        }
        code.append(")\n");
        code.append(program);
        code.append("\n");
        code.append("end\n");
        return code.toString();
    }
}

