/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.eval;

import javax.script.Invocable;
import javax.script.ScriptException;
import org.epochx.tools.eval.ScriptingInterpreter;

public class GroovyInterpreter
extends ScriptingInterpreter {
    public GroovyInterpreter() {
        super("groovy");
    }

    @Override
    public Object[] eval(String expression, String[] argNames, Object[][] argValues) {
        Object[] results = new Object[argValues.length];
        String code = this.getEvalCode(expression, argNames);
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            for (int i = 0; i < results.length; ++i) {
                results[i] = invocableEngine.invokeFunction("expr", argValues[i]);
            }
        }
        catch (ScriptException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return results;
    }

    @Override
    public void exec(String program, String[] argNames, Object[][] argValues) {
        String code = this.getExecCode(program, argNames);
        Invocable invocableEngine = (Invocable)((Object)this.getEngine());
        try {
            this.getEngine().eval(code);
            for (int i = 0; i < argValues.length; ++i) {
                invocableEngine.invokeFunction("expr", argValues[i]);
            }
        }
        catch (ScriptException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }

    private String getEvalCode(String expression, String[] argNames) {
        StringBuilder code = new StringBuilder();
        code.append("public Object expr(");
        for (int i = 0; i < argNames.length; ++i) {
            if (i > 0) {
                code.append(',');
            }
            code.append("Object ");
            code.append(argNames[i]);
        }
        code.append(") {");
        code.append("return ");
        code.append(expression);
        code.append(';');
        code.append("}");
        return code.toString();
    }

    private String getExecCode(String program, String[] argNames) {
        StringBuffer code = new StringBuffer();
        code.append("public Object expr(");
        for (int i = 0; i < argNames.length; ++i) {
            if (i > 0) {
                code.append(',');
            }
            code.append("Object ");
            code.append(argNames[i]);
        }
        code.append(") {");
        code.append(program);
        code.append("}");
        return code.toString();
    }
}

