/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.eval;

import org.epochx.epox.EpoxParser;
import org.epochx.epox.Node;
import org.epochx.epox.Variable;
import org.epochx.tools.eval.Interpreter;
import org.epochx.tools.eval.MalformedProgramException;

public class EpoxInterpreter
implements Interpreter {
    private final EpoxParser parser;

    public EpoxInterpreter() {
        this.parser = new EpoxParser();
    }

    public EpoxInterpreter(EpoxParser parser) {
        this.parser = parser;
    }

    @Override
    public Object eval(String source, String[] argNames, Object[] argValues) throws MalformedProgramException {
        if (source == null) {
            return null;
        }
        this.parser.undeclareAllVariables();
        for (int i = 0; i < argNames.length; ++i) {
            this.parser.declareVariable(new Variable(argNames[i], argValues[i]));
        }
        Node programTree = this.parser.parse(source);
        return programTree.evaluate();
    }

    @Override
    public Object[] eval(String source, String[] argNames, Object[][] argValues) throws MalformedProgramException {
        Object[] results = new Object[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            results[i] = this.eval(source, argNames, argValues[i]);
        }
        return results;
    }

    @Override
    public void exec(String program, String[] argNames, Object[] argValues) {
        throw new IllegalStateException("method not supported");
    }

    @Override
    public void exec(String program, String[] argNames, Object[][] argValues) {
        throw new IllegalStateException("method not supported");
    }

    public EpoxParser getParser() {
        return this.parser;
    }
}

