/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.tools.eval;

import java.util.Arrays;
import org.epochx.tools.eval.Interpreter;

public class BrainfuckInterpreter
implements Interpreter {
    private final byte[] memory;
    private int pointer;

    public BrainfuckInterpreter() {
        this(30000);
    }

    public BrainfuckInterpreter(int memorySize) {
        this.memory = new byte[memorySize];
        this.pointer = 0;
    }

    private void reset() {
        Arrays.fill(this.memory, (byte)0);
        this.pointer = 0;
    }

    @Override
    public Object eval(String program, String[] argNames, Object[] argValues) {
        throw new IllegalStateException("method not supported");
    }

    @Override
    public Object[] eval(String program, String[] argNames, Object[][] argValues) {
        throw new IllegalStateException("method not supported");
    }

    @Override
    public void exec(String program, String[] argNames, Object[] argValues) {
        this.reset();
        for (int i = 0; i < argValues.length; ++i) {
            this.memory[i] = (Byte)argValues[i];
        }
        this.execute(program);
    }

    @Override
    public void exec(String program, String[] argNames, Object[][] argValues) {
        for (int i = 0; i < argValues.length; ++i) {
            this.exec(program, argNames, argValues[i]);
        }
    }

    private void execute(String source) {
        if (source == null) {
            return;
        }
        block10: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '>': {
                    ++this.pointer;
                    this.pointer %= this.memory.length;
                    continue block10;
                }
                case '<': {
                    --this.pointer;
                    if (this.pointer >= 0) continue block10;
                    this.pointer = this.memory.length - 1;
                    continue block10;
                }
                case '+': {
                    int n = this.pointer;
                    this.memory[n] = (byte)(this.memory[n] + 1);
                    continue block10;
                }
                case '-': {
                    int n = this.pointer;
                    this.memory[n] = (byte)(this.memory[n] - 1);
                    continue block10;
                }
                case ',': {
                    continue block10;
                }
                case '.': {
                    continue block10;
                }
                case '[': {
                    int bracketIndex = this.findClosingBracket(source.substring(i + 1)) + (i + 1);
                    String loopSource = source.substring(i + 1, bracketIndex);
                    while (this.memory[this.pointer] != 0) {
                        this.execute(loopSource);
                    }
                    i = bracketIndex;
                    continue block10;
                }
                case ']': {
                    continue block10;
                }
            }
        }
    }

    private int findClosingBracket(String source) {
        int open = 1;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '[') {
                ++open;
                continue;
            }
            if (c != ']' || --open != 0) continue;
            return i;
        }
        return -1;
    }

    public byte[] getMemory() {
        return this.memory;
    }
}

