/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.util.Arrays;

public final class StatsUtils {
    private StatsUtils() {
        assert (false);
    }

    public static double ave(double ... values) {
        if (values != null && values.length != 0) {
            double sum = 0.0;
            for (int i = 0; i < values.length; ++i) {
                sum += values[i];
            }
            return sum / (double)values.length;
        }
        throw new IllegalArgumentException("cannot calculate average of null or empty array of values");
    }

    public static double ave(int ... values) {
        if (values != null && values.length != 0) {
            int sum = 0;
            for (int i = 0; i < values.length; ++i) {
                sum += values[i];
            }
            return (double)sum / (double)values.length;
        }
        throw new IllegalArgumentException("cannot calculate average of null or empty array of values");
    }

    public static double stdev(double ... values) {
        return StatsUtils.stdev(values, StatsUtils.ave(values));
    }

    public static double stdev(double[] values, double ave) {
        if (values != null && values.length != 0) {
            double sqDiff = 0.0;
            for (int i = 0; i < values.length; ++i) {
                sqDiff += Math.pow(values[i] - ave, 2.0);
            }
            return Math.sqrt(sqDiff / (double)values.length);
        }
        throw new IllegalArgumentException("cannot calculate standard deviation of null or empty array of values");
    }

    public static double stdev(int ... values) {
        return StatsUtils.stdev(values, StatsUtils.ave(values));
    }

    public static double stdev(int[] values, double ave) {
        if (values != null && values.length != 0) {
            double sqDiff = 0.0;
            for (int i = 0; i < values.length; ++i) {
                sqDiff += Math.pow((double)values[i] - ave, 2.0);
            }
            return Math.sqrt(sqDiff / (double)values.length);
        }
        throw new IllegalArgumentException("cannot calculate average of null or empty array of values");
    }

    public static int maxIndex(double[] values) {
        if (values != null && values.length != 0) {
            double max = 0.0;
            int maxIndex = -1;
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] > max)) continue;
                max = values[i];
                maxIndex = i;
            }
            return maxIndex;
        }
        throw new IllegalArgumentException("cannot calculate maximum index of null or empty array of values");
    }

    public static int maxIndex(int[] values) {
        if (values != null && values.length != 0) {
            int max = 0;
            int maxIndex = -1;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] <= max) continue;
                max = values[i];
                maxIndex = i;
            }
            return maxIndex;
        }
        throw new IllegalArgumentException("cannot calculate maximum index of null or empty array of values");
    }

    public static int minIndex(double[] values) {
        if (values != null && values.length != 0) {
            double min = Double.MAX_VALUE;
            int minIndex = -1;
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] < min)) continue;
                min = values[i];
                minIndex = i;
            }
            return minIndex;
        }
        throw new IllegalArgumentException("cannot calculate minimum index of null or empty array of values");
    }

    public static int minIndex(int[] values) {
        if (values != null && values.length != 0) {
            int min = Integer.MAX_VALUE;
            int minIndex = -1;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] >= min) continue;
                min = values[i];
                minIndex = i;
            }
            return minIndex;
        }
        throw new IllegalArgumentException("cannot calculate minimum index of null or empty array of values");
    }

    public static double median(double ... values) {
        if (values != null && values.length != 0) {
            Arrays.sort(values);
            int medianIndex = (int)Math.floor(values.length / 2);
            double median = values[medianIndex - 1];
            if (values.length % 2 == 0) {
                median += values[medianIndex];
                median /= 2.0;
            }
            return median;
        }
        throw new IllegalArgumentException("cannot calculate median of null or empty array of values");
    }

    public static double median(int ... values) {
        if (values != null && values.length != 0) {
            Arrays.sort(values);
            int medianIndex = (int)Math.floor(values.length / 2);
            int median = values[medianIndex - 1];
            if (values.length % 2 == 0) {
                median += values[medianIndex];
                median /= 2;
            }
            return median;
        }
        throw new IllegalArgumentException("cannot calculate median of null or empty array of values");
    }

    public static double ci95(double ... values) {
        return StatsUtils.ci95(values, StatsUtils.stdev(values));
    }

    public static double ci95(double[] values, double stdev) {
        double ci = 1.96 * (stdev / Math.sqrt(values.length));
        return ci;
    }

    public static double ci95(int ... values) {
        return StatsUtils.ci95(values, StatsUtils.stdev(values));
    }

    public static double ci95(int[] values, double stdev) {
        double ci = 1.96 * (stdev / Math.sqrt(values.length));
        return ci;
    }
}

