/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.epochx.life.CrossoverAdapter;
import org.epochx.life.ElitismAdapter;
import org.epochx.life.GenerationAdapter;
import org.epochx.life.InitialisationAdapter;
import org.epochx.life.Life;
import org.epochx.life.MutationAdapter;
import org.epochx.life.PoolSelectionAdapter;
import org.epochx.life.RunAdapter;
import org.epochx.stats.Stat;

public class Stats {
    private static Stats instance;
    private final Map<ExpiryEvent, Map<Stat, Object>> data = new HashMap<ExpiryEvent, Map<Stat, Object>>();

    private Stats() {
        ExpiryEvent[] events;
        for (ExpiryEvent e : events = ExpiryEvent.values()) {
            this.data.put(e, new HashMap());
        }
        this.setupListeners();
    }

    public static Stats get() {
        if (instance == null) {
            instance = new Stats();
        }
        return instance;
    }

    public void addData(Stat field, Object value) {
        this.data.get((Object)field.getExpiryEvent()).put(field, value);
    }

    public Object getStat(Stat field) {
        Object value = this.data.get((Object)field.getExpiryEvent()).get(field);
        if (value == null && (value = field.getStatValue()) != null) {
            this.addData(field, value);
        }
        return value;
    }

    public Object[] getStats(Stat ... fields) {
        Object[] stats = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            stats[i] = this.getStat(fields[i]);
        }
        return stats;
    }

    public void print(Stat ... fields) {
        this.print("\t", fields);
    }

    public void print(String separator, Stat ... fields) {
        Object[] stats = this.getStats(fields);
        Stats.printArray(System.out, stats, separator);
    }

    public void printToStream(OutputStream out, Stat ... fields) {
        this.printToStream(out, "\t", fields);
    }

    public void printToStream(OutputStream out, String separator, Stat ... fields) {
        Object[] stats = this.getStats(fields);
        Stats.printArray(out, stats, separator);
    }

    private static void printArray(OutputStream outputStream, Object[] array, String separator) {
        PrintStream out = new PrintStream(outputStream);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                out.print(separator);
            }
            out.print(array[i]);
        }
        out.println();
        out.flush();
    }

    private void setupListeners() {
        Life.get().addRunListener(new RunAdapter(){

            @Override
            public void onRunStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.RUN)).clear();
            }
        });
        Life.get().addGenerationListener(new GenerationAdapter(){

            @Override
            public void onGenerationStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.GENERATION)).clear();
            }
        });
        Life.get().addInitialisationListener(new InitialisationAdapter(){

            @Override
            public void onInitialisationStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.INITIALISATION)).clear();
            }
        });
        Life.get().addElitismListener(new ElitismAdapter(){

            @Override
            public void onElitismStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.INITIALISATION)).clear();
            }
        });
        Life.get().addElitismListener(new ElitismAdapter(){

            @Override
            public void onElitismStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.ELITISM)).clear();
            }
        });
        Life.get().addPoolSelectionListener(new PoolSelectionAdapter(){

            @Override
            public void onPoolSelectionStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.POOL_SELECTION)).clear();
            }
        });
        Life.get().addCrossoverListener(new CrossoverAdapter(){

            @Override
            public void onCrossoverStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.CROSSOVER)).clear();
            }
        });
        Life.get().addMutationListener(new MutationAdapter(){

            @Override
            public void onMutationStart() {
                ((Map)Stats.this.data.get((Object)ExpiryEvent.MUTATION)).clear();
            }
        });
    }

    public static enum ExpiryEvent {
        RUN,
        GENERATION,
        INITIALISATION,
        ELITISM,
        POOL_SELECTION,
        CROSSOVER,
        MUTATION,
        REPRODUCTION;

    }
}

