/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.AbstractStat;
import org.epochx.stats.Stat;
import org.epochx.stats.Stats;
import org.epochx.stats.StatsUtils;

public class StatField {
    public static final Stat RUN_NUMBER = new AbstractStat(Stats.ExpiryEvent.RUN){};
    public static final Stat RUN_TIME = new AbstractStat(Stats.ExpiryEvent.RUN){};
    public static final Stat RUN_TIME_MS = new AbstractStat(Stats.ExpiryEvent.RUN){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(RUN_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat RUN_TIME_S = new AbstractStat(Stats.ExpiryEvent.RUN){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(RUN_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat RUN_TIME_M = new AbstractStat(Stats.ExpiryEvent.RUN){

        @Override
        public Object getStatValue() {
            Long m = null;
            Long ns = (Long)Stats.get().getStat(RUN_TIME);
            if (ns != null) {
                m = TimeUnit.NANOSECONDS.toMinutes(ns);
            }
            return m;
        }
    };
    public static final Stat RUN_TIME_H = new AbstractStat(Stats.ExpiryEvent.RUN){

        @Override
        public Object getStatValue() {
            Long h = null;
            Long ns = (Long)Stats.get().getStat(RUN_TIME);
            if (ns != null) {
                h = TimeUnit.NANOSECONDS.toHours(ns);
            }
            return h;
        }
    };
    public static final Stat RUN_FITNESS_MIN = new AbstractStat(Stats.ExpiryEvent.RUN){};
    public static final Stat RUN_FITTEST_PROGRAM = new AbstractStat(Stats.ExpiryEvent.RUN){};
    public static final Stat INIT_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.INITIALISATION){};
    public static final Stat GEN_NUMBER = new AbstractStat(Stats.ExpiryEvent.GENERATION){};
    public static final Stat GEN_FITNESSES = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            double[] fitnesses = null;
            List pop = (List)Stats.get().getStat(GEN_POP);
            if (pop != null) {
                fitnesses = new double[pop.size()];
                for (int i = 0; i < fitnesses.length; ++i) {
                    fitnesses[i] = ((CandidateProgram)pop.get(i)).getFitness();
                }
            }
            return fitnesses;
        }
    };
    public static final Stat GEN_FITNESS_MIN = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double minFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            if (fitnesses != null) {
                minFitness = NumberUtils.min((double[])fitnesses);
            }
            return minFitness;
        }
    };
    public static final Stat GEN_FITNESS_MAX = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double maxFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            if (fitnesses != null) {
                maxFitness = NumberUtils.max((double[])fitnesses);
            }
            return maxFitness;
        }
    };
    public static final Stat GEN_FITNESS_AVE = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double aveFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            if (fitnesses != null) {
                aveFitness = StatsUtils.ave(fitnesses);
            }
            return aveFitness;
        }
    };
    public static final Stat GEN_FITNESS_STDEV = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double stdevFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            double averageFitness = (Double)Stats.get().getStat(GEN_FITNESS_AVE);
            if (fitnesses != null) {
                stdevFitness = StatsUtils.stdev(fitnesses, averageFitness);
            }
            return stdevFitness;
        }
    };
    public static final Stat GEN_FITNESS_MEDIAN = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double medianFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            if (fitnesses != null) {
                medianFitness = StatsUtils.median(fitnesses);
            }
            return medianFitness;
        }
    };
    public static final Stat GEN_FITNESS_CI95 = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Double ci95Fitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            double stdev = (Double)Stats.get().getStat(GEN_FITNESS_STDEV);
            if (fitnesses != null) {
                ci95Fitness = StatsUtils.ci95(fitnesses, stdev);
            }
            return ci95Fitness;
        }
    };
    public static final Stat GEN_FITTEST_PROGRAM = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            CandidateProgram bestProgram = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            List pop = (List)Stats.get().getStat(GEN_POP);
            if (fitnesses != null) {
                int bestProgramIndex = StatsUtils.minIndex(fitnesses);
                bestProgram = (CandidateProgram)pop.get(bestProgramIndex);
            }
            return bestProgram;
        }
    };
    public static final Stat GEN_FITTEST_PROGRAMS = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            ArrayList bestPrograms = new ArrayList();
            Double minFitness = (Double)Stats.get().getStat(GEN_FITNESS_MIN);
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            List pop = (List)Stats.get().getStat(GEN_POP);
            if (minFitness != null && fitnesses != null) {
                for (int i = 0; i < fitnesses.length; ++i) {
                    double fitness = fitnesses[i];
                    if (fitness != minFitness) continue;
                    bestPrograms.add(pop.get(i));
                }
            }
            return bestPrograms;
        }
    };
    public static final Stat GEN_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.GENERATION){};
    public static final Stat GEN_POP = new AbstractStat(Stats.ExpiryEvent.GENERATION){};
    public static final Stat GEN_POP_SORTED = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            ArrayList sortedPop = null;
            List pop = (List)Stats.get().getStat(GEN_POP);
            if (pop != null) {
                sortedPop = new ArrayList(pop);
                Collections.sort(sortedPop);
            }
            return sortedPop;
        }
    };
    public static final Stat GEN_POP_SORTED_DESC = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            ArrayList sortedPop = null;
            List pop = (List)Stats.get().getStat(GEN_POP);
            if (pop != null) {
                sortedPop = new ArrayList(pop);
                Collections.sort(sortedPop, Collections.reverseOrder());
            }
            return sortedPop;
        }
    };
    public static final Stat GEN_FITNESSES_SORTED = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            double[] sortedFitnesses = null;
            double[] fitnesses = (double[])Stats.get().getStat(GEN_FITNESSES);
            if (fitnesses != null) {
                sortedFitnesses = (double[])fitnesses.clone();
                Arrays.sort(sortedFitnesses);
            }
            return sortedFitnesses;
        }
    };
    public static final Stat GEN_FITNESSES_SORTED_DESC = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            double[] sortedFitnessesDesc = null;
            double[] sortedFitnesses = (double[])Stats.get().getStat(GEN_FITNESSES_SORTED);
            if (sortedFitnesses != null) {
                sortedFitnessesDesc = (double[])sortedFitnesses.clone();
                ArrayUtils.reverse((double[])sortedFitnessesDesc);
            }
            return sortedFitnessesDesc;
        }
    };
    public static final Stat GEN_TIME = new AbstractStat(Stats.ExpiryEvent.GENERATION){};
    public static final Stat GEN_TIME_MS = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(GEN_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat GEN_TIME_S = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(GEN_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat GEN_TIME_M = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Long m = null;
            Long ns = (Long)Stats.get().getStat(GEN_TIME);
            if (ns != null) {
                m = TimeUnit.NANOSECONDS.toMinutes(ns);
            }
            return m;
        }
    };
    public static final Stat GEN_TIME_H = new AbstractStat(Stats.ExpiryEvent.GENERATION){

        @Override
        public Object getStatValue() {
            Long h = null;
            Long ns = (Long)Stats.get().getStat(GEN_TIME);
            if (ns != null) {
                h = TimeUnit.NANOSECONDS.toHours(ns);
            }
            return h;
        }
    };
    public static final Stat MUT_PARENT = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    public static final Stat MUT_CHILD = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    public static final Stat MUT_TIME = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    public static final Stat MUT_TIME_MS = new AbstractStat(Stats.ExpiryEvent.MUTATION){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(MUT_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat MUT_TIME_S = new AbstractStat(Stats.ExpiryEvent.MUTATION){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(MUT_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat MUT_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.MUTATION){};
    public static final Stat MUT_PARENT_FITNESS = new AbstractStat(Stats.ExpiryEvent.MUTATION){

        @Override
        public Object getStatValue() {
            Double fitness = null;
            CandidateProgram parent = (CandidateProgram)Stats.get().getStat(MUT_PARENT);
            if (parent != null) {
                fitness = parent.getFitness();
            }
            return fitness;
        }
    };
    public static final Stat MUT_CHILD_FITNESS = new AbstractStat(Stats.ExpiryEvent.MUTATION){

        @Override
        public Object getStatValue() {
            Double fitness = null;
            CandidateProgram child = (CandidateProgram)Stats.get().getStat(MUT_CHILD);
            if (child != null) {
                fitness = child.getFitness();
            }
            return fitness;
        }
    };
    public static final Stat MUT_FITNESS_CHANGE = new AbstractStat(Stats.ExpiryEvent.MUTATION){

        @Override
        public Object getStatValue() {
            Double fitnessChange = null;
            Double fitnessBefore = (Double)Stats.get().getStat(MUT_PARENT_FITNESS);
            Double fitnessAfter = (Double)Stats.get().getStat(MUT_CHILD_FITNESS);
            if (fitnessBefore != null && fitnessAfter != null) {
                fitnessChange = fitnessAfter - fitnessBefore;
            }
            return fitnessChange;
        }
    };
    public static final Stat XO_PARENTS = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_CHILDREN = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_TIME = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_TIME_MS = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(XO_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat XO_TIME_S = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(XO_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat XO_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){};
    public static final Stat XO_PARENT_FITNESSES = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            double[] fitnesses = null;
            CandidateProgram[] parents = (CandidateProgram[])Stats.get().getStat(XO_PARENTS);
            if (parents != null) {
                fitnesses = new double[parents.length];
                for (int i = 0; i < parents.length; ++i) {
                    fitnesses[i] = parents[i].getFitness();
                }
            }
            return fitnesses;
        }
    };
    public static final Stat XO_CHILD_FITNESSES = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            double[] fitnesses = null;
            CandidateProgram[] children = (CandidateProgram[])Stats.get().getStat(XO_CHILDREN);
            if (children != null) {
                fitnesses = new double[children.length];
                for (int i = 0; i < children.length; ++i) {
                    fitnesses[i] = children[i].getFitness();
                }
            }
            return fitnesses;
        }
    };
    public static final Stat XO_PARENTS_FITNESS_AVE = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            Double aveFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(XO_PARENT_FITNESSES);
            if (fitnesses != null) {
                aveFitness = StatsUtils.ave(fitnesses);
            }
            return aveFitness;
        }
    };
    public static final Stat XO_CHILDREN_FITNESS_AVE = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            Double aveFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(XO_CHILD_FITNESSES);
            if (fitnesses != null) {
                aveFitness = StatsUtils.ave(fitnesses);
            }
            return aveFitness;
        }
    };
    public static final Stat XO_FITNESS_AVE_CHANGE = new AbstractStat(Stats.ExpiryEvent.CROSSOVER){

        @Override
        public Object getStatValue() {
            Double fitnessChange = null;
            Double aveFitnessBefore = (Double)Stats.get().getStat(XO_PARENTS_FITNESS_AVE);
            Double aveFitnessAfter = (Double)Stats.get().getStat(XO_CHILDREN_FITNESS_AVE);
            if (aveFitnessBefore != null && aveFitnessAfter != null) {
                fitnessChange = aveFitnessAfter - aveFitnessBefore;
            }
            return fitnessChange;
        }
    };
    public static final Stat POOL_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){};
    public static final Stat POOL_FITNESSES = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            double[] fitnesses = null;
            List pop = (List)Stats.get().getStat(POOL_PROGRAMS);
            if (pop != null) {
                fitnesses = new double[pop.size()];
                for (int i = 0; i < fitnesses.length; ++i) {
                    fitnesses[i] = ((CandidateProgram)pop.get(i)).getFitness();
                }
            }
            return fitnesses;
        }
    };
    public static final Stat POOL_FITNESS_MIN = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double minFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            if (fitnesses != null) {
                minFitness = NumberUtils.min((double[])fitnesses);
            }
            return minFitness;
        }
    };
    public static final Stat POOL_FITNESS_MAX = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double maxFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            if (fitnesses != null) {
                maxFitness = NumberUtils.max((double[])fitnesses);
            }
            return maxFitness;
        }
    };
    public static final Stat POOL_FITNESS_AVE = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double aveFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            if (fitnesses != null) {
                aveFitness = StatsUtils.ave(fitnesses);
            }
            return aveFitness;
        }
    };
    public static final Stat POOL_FITNESS_STDEV = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double stdevFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            double averageFitness = (Double)Stats.get().getStat(POOL_FITNESS_AVE);
            if (fitnesses != null) {
                stdevFitness = StatsUtils.stdev(fitnesses, averageFitness);
            }
            return stdevFitness;
        }
    };
    public static final Stat POOL_FITNESS_MEDIAN = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double medianFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            if (fitnesses != null) {
                medianFitness = StatsUtils.median(fitnesses);
            }
            return medianFitness;
        }
    };
    public static final Stat POOL_FITNESS_CI95 = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Double ci95Fitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            double stdev = (Double)Stats.get().getStat(POOL_FITNESS_STDEV);
            if (fitnesses != null) {
                ci95Fitness = StatsUtils.ci95(fitnesses, stdev);
            }
            return ci95Fitness;
        }
    };
    public static final Stat POOL_FITTEST_PROGRAM = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            CandidateProgram bestProgram = null;
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            List pool = (List)Stats.get().getStat(POOL_PROGRAMS);
            if (fitnesses != null) {
                int bestProgramIndex = StatsUtils.minIndex(fitnesses);
                bestProgram = (CandidateProgram)pool.get(bestProgramIndex);
            }
            return bestProgram;
        }
    };
    public static final Stat POOL_FITTEST_PROGRAMS = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            ArrayList bestPrograms = new ArrayList();
            Double minFitness = (Double)Stats.get().getStat(POOL_FITNESS_MIN);
            double[] fitnesses = (double[])Stats.get().getStat(POOL_FITNESSES);
            List pool = (List)Stats.get().getStat(POOL_PROGRAMS);
            if (minFitness != null && fitnesses != null) {
                for (int i = 0; i < fitnesses.length; ++i) {
                    double fitness = fitnesses[i];
                    if (fitness != minFitness) continue;
                    bestPrograms.add(pool.get(i));
                }
            }
            return bestPrograms;
        }
    };
    public static final Stat POOL_PROGRAMS = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){};
    public static final Stat POOL_SIZE = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Integer poolSize = null;
            List pool = (List)Stats.get().getStat(XO_PARENTS_FITNESS_AVE);
            if (pool != null) {
                poolSize = pool.size();
            }
            return poolSize;
        }
    };
    public static final Stat POOL_TIME = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){};
    public static final Stat POOL_TIME_MS = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(POOL_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat POOL_TIME_S = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(POOL_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat POOL_TIME_M = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(POOL_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toMinutes(ns);
            }
            return s;
        }
    };
    public static final Stat POOL_TIME_H = new AbstractStat(Stats.ExpiryEvent.POOL_SELECTION){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(POOL_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toHours(ns);
            }
            return s;
        }
    };
    public static final Stat REP_REVERSIONS = new AbstractStat(Stats.ExpiryEvent.REPRODUCTION){};
    public static final Stat REP_TIME = new AbstractStat(Stats.ExpiryEvent.REPRODUCTION){};
    public static final Stat ELITE_PROGRAMS = new AbstractStat(Stats.ExpiryEvent.ELITISM){};
    public static final Stat ELITE_SIZE = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Integer eliteSize = null;
            List elites = (List)Stats.get().getStat(ELITE_PROGRAMS);
            if (elites != null) {
                eliteSize = elites.size();
            }
            return eliteSize;
        }
    };
    public static final Stat ELITE_FITNESSES = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            double[] fitnesses = null;
            List elites = (List)Stats.get().getStat(ELITE_PROGRAMS);
            if (elites != null) {
                fitnesses = new double[elites.size()];
                for (int i = 0; i < fitnesses.length; ++i) {
                    fitnesses[i] = ((CandidateProgram)elites.get(i)).getFitness();
                }
            }
            return fitnesses;
        }
    };
    public static final Stat ELITE_FITNESS_MIN = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double minFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            if (fitnesses != null) {
                minFitness = NumberUtils.min((double[])fitnesses);
            }
            return minFitness;
        }
    };
    public static final Stat ELITE_FITNESS_MAX = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double maxFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            if (fitnesses != null) {
                maxFitness = NumberUtils.max((double[])fitnesses);
            }
            return maxFitness;
        }
    };
    public static final Stat ELITE_FITNESS_AVE = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double aveFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            if (fitnesses != null) {
                aveFitness = StatsUtils.ave(fitnesses);
            }
            return aveFitness;
        }
    };
    public static final Stat ELITE_FITNESS_STDEV = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double stdevFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            double averageFitness = (Double)Stats.get().getStat(ELITE_FITNESS_AVE);
            if (fitnesses != null) {
                stdevFitness = StatsUtils.stdev(fitnesses, averageFitness);
            }
            return stdevFitness;
        }
    };
    public static final Stat ELITE_FITNESS_MEDIAN = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double medianFitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            if (fitnesses != null) {
                medianFitness = StatsUtils.median(fitnesses);
            }
            return medianFitness;
        }
    };
    public static final Stat ELITE_FITNESS_CI95 = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Double ci95Fitness = null;
            double[] fitnesses = (double[])Stats.get().getStat(ELITE_FITNESSES);
            double stdev = (Double)Stats.get().getStat(ELITE_FITNESS_STDEV);
            if (fitnesses != null) {
                ci95Fitness = StatsUtils.ci95(fitnesses, stdev);
            }
            return ci95Fitness;
        }
    };
    public static final Stat ELITE_TIME = new AbstractStat(Stats.ExpiryEvent.ELITISM){};
    public static final Stat ELITE_TIME_MS = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Long ms = null;
            Long ns = (Long)Stats.get().getStat(ELITE_TIME);
            if (ns != null) {
                ms = TimeUnit.NANOSECONDS.toMillis(ns);
            }
            return ms;
        }
    };
    public static final Stat ELITE_TIME_S = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(ELITE_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toSeconds(ns);
            }
            return s;
        }
    };
    public static final Stat ELITE_TIME_M = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(ELITE_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toMinutes(ns);
            }
            return s;
        }
    };
    public static final Stat ELITE_TIME_H = new AbstractStat(Stats.ExpiryEvent.ELITISM){

        @Override
        public Object getStatValue() {
            Long s = null;
            Long ns = (Long)Stats.get().getStat(ELITE_TIME);
            if (ns != null) {
                s = TimeUnit.NANOSECONDS.toHours(ns);
            }
            return s;
        }
    };
}

